import stampit from 'stampit';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  patternProperties: JSONSchemaPatternPropertiesVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const PatternPropertiesVisitor = stampit(JSONSchemaPatternPropertiesVisitor, {
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = JSONSchemaPatternPropertiesVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default PatternPropertiesVisitor;