import stampit from 'stampit';
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import { isReferenceElement } from "../../../../predicates.js";
const {
  properties: JSONSchemaPropertiesVisitor
} = JSONSchemaDraft4Specification.visitors.document.objects.JSONSchema.fixedFields;
const PropertiesVisitor = stampit(JSONSchemaPropertiesVisitor, {
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = JSONSchemaPropertiesVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'schema');
      });
      return result;
    }
  }
});
export default PropertiesVisitor;