import stampit from 'stampit';
import { always } from 'ramda';
import SecuritySchemeElement from "../../../../elements/SecurityScheme.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
const SecuritySchemeVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'SecurityScheme']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new SecuritySchemeElement();
  }
});
export default SecuritySchemeVisitor;