import stampit from 'stampit';
import { isReferenceLikeElement, MapVisitor, FallbackVisitor } from '@swagger-api/apidom-ns-openapi-3-0';
import ComponentsPathItemsElement from "../../../../elements/nces/ComponentsPathItems.js";
import { isReferenceElement } from "../../../../predicates.js";
const PathItemsVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new ComponentsPathItemsElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });
      return result;
    }
  }
});
export default PathItemsVisitor;