"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
var _ComponentsPathItems = _interopRequireDefault(require("../../../../elements/nces/ComponentsPathItems.cjs"));
var _predicates = require("../../../../predicates.cjs");
const PathItemsVisitor = (0, _stampit.default)(_apidomNsOpenapi.MapVisitor, _apidomNsOpenapi.FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return (0, _apidomNsOpenapi.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new _ComponentsPathItems.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _apidomNsOpenapi.MapVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(_predicates.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });
      return result;
    }
  }
});
var _default = PathItemsVisitor;
exports.default = _default;