"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
var _predicates = require("../../../../predicates.cjs");
var _Schema = _interopRequireDefault(require("../../../../elements/Schema.cjs"));
var _JsonSchemaDialect = _interopRequireDefault(require("../../../../elements/JsonSchemaDialect.cjs"));
var _ParentSchemaAwareVisitor = _interopRequireDefault(require("./ParentSchemaAwareVisitor.cjs"));
const SchemaVisitor = (0, _stampit.default)(_apidomNsOpenapi.FixedFieldsVisitor, _ParentSchemaAwareVisitor.default, _apidomNsOpenapi.FallbackVisitor, {
  props: {
    specPath: (0, _ramda.always)(['document', 'objects', 'Schema']),
    canSupportSpecificationExtensions: true
  },
  // @ts-ignore
  init() {
    /**
     * Private Api.
     */

    /**
     * This function depends on some external context, so we need to make sure this function
     * works even when no context is provided like when directly refracting generic Object Element
     * into Schema Element: SchemaElement.refract(new ObjectElement({ type: 'object' });
     */
    const getJsonSchemaDialect = () => {
      let jsonSchemaDialect;
      if (this.openApiSemanticElement !== null && (0, _predicates.isJsonSchemaDialectElement)(this.openApiSemanticElement.jsonSchemaDialect)) {
        jsonSchemaDialect = this.openApiSemanticElement.jsonSchemaDialect.toValue();
      } else if (this.openApiGenericElement !== null && (0, _apidomCore.isStringElement)(this.openApiGenericElement.get('jsonSchemaDialect'))) {
        jsonSchemaDialect = this.openApiGenericElement.get('jsonSchemaDialect').toValue();
      } else {
        jsonSchemaDialect = _JsonSchemaDialect.default.default.toValue();
      }
      return jsonSchemaDialect;
    };
    const handle$schema = objectElement => {
      // handle $schema keyword in embedded resources
      if ((0, _ramdaAdjunct.isNull)(this.parent) && !(0, _apidomCore.isStringElement)(objectElement.get('$schema'))) {
        // no parent available and no $schema is defined, set default jsonSchemaDialect
        this.element.setMetaProperty('inherited$schema', getJsonSchemaDialect());
      } else if ((0, _predicates.isSchemaElement)(this.parent) && !(0, _apidomCore.isStringElement)(objectElement.get('$schema'))) {
        var _this$parent$meta$get, _this$parent$$schema;
        // parent is available and no $schema is defined, set parent $schema
        const inherited$schema = (0, _ramda.defaultTo)((_this$parent$meta$get = this.parent.meta.get('inherited$schema')) === null || _this$parent$meta$get === void 0 ? void 0 : _this$parent$meta$get.toValue(), (_this$parent$$schema = this.parent.$schema) === null || _this$parent$$schema === void 0 ? void 0 : _this$parent$$schema.toValue());
        this.element.setMetaProperty('inherited$schema', inherited$schema);
      }
    };
    const handle$id = objectElement => {
      var _objectElement$get;
      // handle $id keyword in embedded resources
      // fetch parent's inherited$id
      const inherited$id = this.parent !== null ? this.parent.getMetaProperty('inherited$id', []).clone() : new _apidomCore.ArrayElement();
      // get current $id keyword
      const $id = (_objectElement$get = objectElement.get('$id')) === null || _objectElement$get === void 0 ? void 0 : _objectElement$get.toValue();

      // remember $id keyword if it's a non empty strings
      if ((0, _ramdaAdjunct.isNonEmptyString)($id)) {
        inherited$id.push($id);
      }
      this.element.setMetaProperty('inherited$id', inherited$id);
    };

    /**
     * Public Api.
     */
    // eslint-disable-next-line @typescript-eslint/naming-convention
    this.ObjectElement = function _ObjectElement(objectElement) {
      this.element = new _Schema.default();
      handle$schema(objectElement);
      handle$id(objectElement);

      // for further processing consider this Schema Element as parent for all embedded Schema Elements
      this.parent = this.element;
      // @ts-ignore
      const result = _apidomNsOpenapi.FixedFieldsVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // mark this SchemaElement with reference metadata
      if ((0, _apidomCore.isStringElement)(this.element.$ref)) {
        this.element.classes.push('reference-element');
        this.element.setMetaProperty('referenced-element', 'schema');
      }
      return result;
    };

    // eslint-disable-next-line @typescript-eslint/naming-convention
    this.BooleanElement = function _BooleanElement(booleanElement) {
      this.element = booleanElement.clone();
      this.element.classes.push('boolean-json-schema');
      return _apidomCore.BREAK;
    };
  }
});
var _default = SchemaVisitor;
exports.default = _default;