/// <reference types="@swagger-api/apidom-core/types/minim" />
import * as _swagger_api_apidom_core from '@swagger-api/apidom-core';
import { MediaTypes, NamespacePluginOptions, isStringElement, isArrayElement, isObjectElement, includesClasses, MemberElement, StringElement, ObjectElement, Meta, Attributes, ArrayElement, Namespace, Element, NumberElement, BooleanElement } from '@swagger-api/apidom-core';
export { isArrayElement, isBooleanElement, isElement, isLinkElement as isLinkPrimitiveElement, isMemberElement, isNullElement, isNumberElement, isObjectElement, isRefElement, isStringElement } from '@swagger-api/apidom-core';
import * as minim from 'minim';
import { LinkElement, RequestBodyElement, ReferenceElement, OperationElement, PathItemElement, OpenapiElement, LicenseElement, InfoElement, ComponentsElement, PathsElement, ExternalDocumentationElement, XmlElement, DiscriminatorElement, ParameterElement, HeaderElement, CallbackElement, ContactElement, EncodingElement, ExampleElement, MediaTypeElement, OAuthFlowElement, OAuthFlowsElement, ResponseElement, ResponsesElement, SecurityRequirementElement, SecuritySchemeElement, ServerElement, ServerVariableElement, TagElement } from '@swagger-api/apidom-ns-openapi-3-0';
export { ComponentsCallbacksElement, ComponentsExamplesElement, ComponentsHeadersElement, ComponentsLinksElement, ComponentsParametersElement, ComponentsRequestBodiesElement, ComponentsResponsesElement, ComponentsSchemasElement, ComponentsSecuritySchemesElement, DiscriminatorMappingElement, EncodingHeadersElement, HeaderContentElement, HeaderExamplesElement, LinkParametersElement, MediaTypeEncodingElement, MediaTypeExamplesElement, OAuthFlowScopesElement, OperationCallbacksElement, OperationParametersElement, OperationSecurityElement, OperationServersElement, OperationTagsElement, ParameterContentElement, ParameterExamplesElement, PathItemParametersElement, PathItemServersElement, RequestBodyContentElement, ResponseContentElement, ResponseHeadersElement, ResponseLinksElement, SecurityElement, ServerVariablesElement, ServersElement, TagsElement, isOpenApiExtension, isParameterLikeElement, isReferenceLikeElement, isResponseLikeElement, isServerLikeElement } from '@swagger-api/apidom-ns-openapi-3-0';

type Format = 'generic' | 'json' | 'yaml';
declare class OpenAPIMediaTypes extends MediaTypes<string> {
    filterByFormat(format?: Format): string[];
    findBy(version?: string, format?: Format): string;
    latest(format?: Format): string;
}
declare const mediaTypes: OpenAPIMediaTypes;

declare const openApi3_1: {
    namespace: (options: NamespacePluginOptions) => minim.Namespace;
};

declare class Link extends LinkElement {
}

declare class RequestBody extends RequestBodyElement {
}

declare class Reference extends ReferenceElement {
}

declare class Operation extends OperationElement {
    get requestBody(): RequestBody | Reference | undefined;
    set requestBody(requestBody: RequestBody | Reference | undefined);
}

declare class PathItem extends PathItemElement {
    get GET(): Operation;
    set GET(operation: Operation | undefined);
    get PUT(): Operation;
    set PUT(operation: Operation | undefined);
    get POST(): Operation;
    set POST(operation: Operation | undefined);
    get DELETE(): Operation;
    set DELETE(operation: Operation | undefined);
    get OPTIONS(): Operation;
    set OPTIONS(operation: Operation | undefined);
    get HEAD(): Operation;
    set HEAD(operation: Operation | undefined);
    get PATCH(): Operation;
    set PATCH(operation: Operation | undefined);
    get TRACE(): Operation;
    set TRACE(operation: Operation | undefined);
}

declare const isCallbackElement: (element: any) => boolean;
declare const isComponentsElement: (element: any) => boolean;
declare const isContactElement: (element: any) => boolean;
declare const isExampleElement: (element: any) => boolean;
declare const isExternalDocumentationElement: (element: any) => boolean;
declare const isHeaderElement: (element: any) => boolean;
declare const isInfoElement: (element: any) => boolean;
declare const isJsonSchemaDialectElement: (element: any) => boolean;
declare const isLicenseElement: (element: any) => boolean;
declare const isLinkElement: (element: any) => boolean;
declare const isLinkElementExternal: (element: any) => element is Link;
declare const isOpenapiElement: (element: any) => boolean;
declare const isOpenApi3_1Element: (element: any) => boolean;
declare const isOperationElement: (element: any) => boolean;
declare const isParameterElement: (element: any) => boolean;
declare const isPathItemElement: (element: any) => boolean;
declare const isPathItemElementExternal: (element: any) => element is PathItem;
declare const isPathsElement: (element: any) => boolean;
declare const isReferenceElement: (element: any) => boolean;
declare const isReferenceElementExternal: (element: any) => element is Reference;
declare const isRequestBodyElement: (element: any) => boolean;
declare const isResponseElement: (element: any) => boolean;
declare const isResponsesElement: (element: any) => boolean;
declare const isSchemaElement: (element: any) => boolean;
declare const isBooleanJsonSchemaElement: (element: any) => any;
declare const isSecurityRequirementElement: (element: any) => boolean;
declare const isServerElement: (element: any) => boolean;
declare const isServerVariableElement: (element: any) => boolean;
declare const isMediaTypeElement: (element: any) => boolean;

declare const openApi3_1Predicates_isCallbackElement: typeof isCallbackElement;
declare const openApi3_1Predicates_isComponentsElement: typeof isComponentsElement;
declare const openApi3_1Predicates_isContactElement: typeof isContactElement;
declare const openApi3_1Predicates_isExampleElement: typeof isExampleElement;
declare const openApi3_1Predicates_isExternalDocumentationElement: typeof isExternalDocumentationElement;
declare const openApi3_1Predicates_isHeaderElement: typeof isHeaderElement;
declare const openApi3_1Predicates_isInfoElement: typeof isInfoElement;
declare const openApi3_1Predicates_isJsonSchemaDialectElement: typeof isJsonSchemaDialectElement;
declare const openApi3_1Predicates_isLicenseElement: typeof isLicenseElement;
declare const openApi3_1Predicates_isLinkElement: typeof isLinkElement;
declare const openApi3_1Predicates_isLinkElementExternal: typeof isLinkElementExternal;
declare const openApi3_1Predicates_isOpenapiElement: typeof isOpenapiElement;
declare const openApi3_1Predicates_isOpenApi3_1Element: typeof isOpenApi3_1Element;
declare const openApi3_1Predicates_isOperationElement: typeof isOperationElement;
declare const openApi3_1Predicates_isParameterElement: typeof isParameterElement;
declare const openApi3_1Predicates_isPathItemElement: typeof isPathItemElement;
declare const openApi3_1Predicates_isPathItemElementExternal: typeof isPathItemElementExternal;
declare const openApi3_1Predicates_isPathsElement: typeof isPathsElement;
declare const openApi3_1Predicates_isReferenceElement: typeof isReferenceElement;
declare const openApi3_1Predicates_isReferenceElementExternal: typeof isReferenceElementExternal;
declare const openApi3_1Predicates_isRequestBodyElement: typeof isRequestBodyElement;
declare const openApi3_1Predicates_isResponseElement: typeof isResponseElement;
declare const openApi3_1Predicates_isResponsesElement: typeof isResponsesElement;
declare const openApi3_1Predicates_isSchemaElement: typeof isSchemaElement;
declare const openApi3_1Predicates_isBooleanJsonSchemaElement: typeof isBooleanJsonSchemaElement;
declare const openApi3_1Predicates_isSecurityRequirementElement: typeof isSecurityRequirementElement;
declare const openApi3_1Predicates_isServerElement: typeof isServerElement;
declare const openApi3_1Predicates_isServerVariableElement: typeof isServerVariableElement;
declare const openApi3_1Predicates_isMediaTypeElement: typeof isMediaTypeElement;
declare namespace openApi3_1Predicates {
  export {
    openApi3_1Predicates_isCallbackElement as isCallbackElement,
    openApi3_1Predicates_isComponentsElement as isComponentsElement,
    openApi3_1Predicates_isContactElement as isContactElement,
    openApi3_1Predicates_isExampleElement as isExampleElement,
    openApi3_1Predicates_isExternalDocumentationElement as isExternalDocumentationElement,
    openApi3_1Predicates_isHeaderElement as isHeaderElement,
    openApi3_1Predicates_isInfoElement as isInfoElement,
    openApi3_1Predicates_isJsonSchemaDialectElement as isJsonSchemaDialectElement,
    openApi3_1Predicates_isLicenseElement as isLicenseElement,
    openApi3_1Predicates_isLinkElement as isLinkElement,
    openApi3_1Predicates_isLinkElementExternal as isLinkElementExternal,
    openApi3_1Predicates_isOpenapiElement as isOpenapiElement,
    openApi3_1Predicates_isOpenApi3_1Element as isOpenApi3_1Element,
    openApi3_1Predicates_isOperationElement as isOperationElement,
    openApi3_1Predicates_isParameterElement as isParameterElement,
    openApi3_1Predicates_isPathItemElement as isPathItemElement,
    openApi3_1Predicates_isPathItemElementExternal as isPathItemElementExternal,
    openApi3_1Predicates_isPathsElement as isPathsElement,
    openApi3_1Predicates_isReferenceElement as isReferenceElement,
    openApi3_1Predicates_isReferenceElementExternal as isReferenceElementExternal,
    openApi3_1Predicates_isRequestBodyElement as isRequestBodyElement,
    openApi3_1Predicates_isResponseElement as isResponseElement,
    openApi3_1Predicates_isResponsesElement as isResponsesElement,
    openApi3_1Predicates_isSchemaElement as isSchemaElement,
    openApi3_1Predicates_isBooleanJsonSchemaElement as isBooleanJsonSchemaElement,
    openApi3_1Predicates_isSecurityRequirementElement as isSecurityRequirementElement,
    openApi3_1Predicates_isServerElement as isServerElement,
    openApi3_1Predicates_isServerVariableElement as isServerVariableElement,
    openApi3_1Predicates_isMediaTypeElement as isMediaTypeElement,
  };
}

type Predicates = typeof openApi3_1Predicates & {
    isStringElement: typeof isStringElement;
    isArrayElement: typeof isArrayElement;
    isObjectElement: typeof isObjectElement;
    includesClasses: typeof includesClasses;
};
declare const createToolbox: () => {
    predicates: Predicates;
    namespace: _swagger_api_apidom_core.Namespace;
};

declare const plugin$6: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        MemberElement(element: MemberElement, ...rest: any): MemberElement | undefined;
        StringElement(element: StringElement, ...rest: any): any;
    };
};

/**
 * Inheritance of Parameter Objects.
 *
 * OpenAPI 3.1 specification excerpt that defines the inheritance behavior:
 *
 * A list of parameters that are applicable for this operation. If a parameter is already defined at the Path Item,
 * the new definition will override it but can never remove it. The list MUST NOT include duplicated parameters.
 * A unique parameter is defined by a combination of a name and location.
 */
declare const plugin$5: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        PathItemElement: {
            enter(pathItemElement: PathItem, key: any, parent: any, path: any, ancestors: any[]): void;
            leave(): void;
        };
        OperationElement: {
            leave(operationElement: Operation): void;
        };
    };
};

declare class Openapi extends OpenapiElement {
}

declare class License extends LicenseElement {
    get identifier(): StringElement | undefined;
    set identifier(name: StringElement | undefined);
}

declare class Info extends InfoElement {
    get license(): License | undefined;
    set license(licenseElement: License | undefined);
    get summary(): StringElement | undefined;
    set summary(summary: StringElement | undefined);
}

declare class Components extends ComponentsElement {
    get pathItems(): ObjectElement | undefined;
    set pathItems(pathItems: ObjectElement | undefined);
}

declare class Paths extends PathsElement {
}

declare class ExternalDocumentation extends ExternalDocumentationElement {
}

declare class OpenApi3_1 extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    get openapi(): Openapi | undefined;
    set openapi(openapi: Openapi | undefined);
    get info(): Info | undefined;
    set info(info: Info | undefined);
    get jsonSchemaDialect(): StringElement | undefined;
    set jsonSchemaDialect(jsonSchemaDialect: StringElement | undefined);
    get servers(): ArrayElement | undefined;
    set servers(servers: ArrayElement | undefined);
    get paths(): Paths | undefined;
    set paths(paths: Paths | undefined);
    get components(): Components | undefined;
    set components(components: Components | undefined);
    get security(): ArrayElement | undefined;
    set security(security: ArrayElement | undefined);
    get tags(): ArrayElement | undefined;
    set tags(tags: ArrayElement | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
    get webhooks(): ObjectElement | undefined;
    set webhooks(webhooks: ObjectElement | undefined);
}

/**
 * Override of Security Requirement Objects.
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * Operation.security definition overrides any declared top-level security.
 * To remove a top-level security declaration, an empty array can be used.
 * When a list of Security Requirement Objects is defined on the OpenAPI Object or Operation Object,
 * only one of the Security Requirement Objects in the list needs to be satisfied to authorize the request.
 */
declare const plugin$4: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        OpenApi3_1Element: {
            enter(openapiElement: OpenApi3_1): void;
            leave(): void;
        };
        OperationElement: {
            leave(operationElement: Operation, key: any, parent: any, path: any, ancestors: any[]): void;
        };
    };
};

/**
 * Override of Server Objects.
 *
 * List of Server Objects can be defined in OpenAPI 3.1 on multiple levels:
 *
 *  - OpenAPI.servers
 *  - PathItem.servers
 *  - Operation.servers
 *
 * If an alternative server object is specified at the Path Item Object level, it will override OpenAPI.servers.
 * If an alternative server object is specified at the Operation Object level, it will override PathItem.servers and OpenAPI.servers respectively.
 */
declare const plugin$3: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        OpenApi3_1Element: {
            enter(openapiElement: OpenApi3_1): void;
            leave(): void;
        };
        PathItemElement: {
            enter(pathItemElement: PathItem, key: any, parent: any, path: any, ancestors: any[]): void;
            leave(): void;
        };
        OperationElement: {
            enter(operationElement: Operation): void;
        };
    };
};

/**
 * Normalization of Operation.operationId field.
 *
 * This normalization is not guided by OpenAPI 3.1 specification.
 *
 * Existing Operation.operationId fields are normalized into snake case form.
 *
 * Operation Objects, that do not define operationId field, are left untouched.
 *
 * Original operationId is stored in meta and as new `__originalOperationId` field.
 *
 * This plugin also guarantees the uniqueness of all defined Operation.operationId fields,
 * and make sure Link.operationId fields are pointing to correct and normalized Operation.operationId fields.
 *
 */
declare const plugin$2: ({ operationIdNormalizer }?: {
    operationIdNormalizer?: ((operationId: string, path: string, method: string) => string) | undefined;
}) => ({ predicates, namespace }: {
    predicates: Predicates;
    namespace: Namespace;
}) => {
    visitor: {
        OpenApi3_1Element: {
            leave(): void;
        };
        PathItemElement: {
            enter(pathItemElement: PathItem): void;
            leave(): void;
        };
        OperationElement: {
            enter(operationElement: Operation): void;
        };
        LinkElement: {
            leave(linkElement: Link): void;
        };
    };
};

declare class Xml extends XmlElement {
}

declare class Discriminator extends DiscriminatorElement {
}

declare class Schema extends ObjectElement {
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
    /**
     * Core vocabulary
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/core
     */
    get $schema(): StringElement | undefined;
    set $schema($schema: StringElement | undefined);
    get $vocabulary(): ObjectElement | undefined;
    set $vocabulary($vocabulary: ObjectElement | undefined);
    get $id(): StringElement | undefined;
    set $id($id: StringElement | undefined);
    get $anchor(): StringElement | undefined;
    set $anchor($anchor: StringElement | undefined);
    get $dynamicAnchor(): StringElement | undefined;
    set $dynamicAnchor($dynamicAnchor: StringElement | undefined);
    get $dynamicRef(): StringElement | undefined;
    set $dynamicRef($dynamicRef: StringElement | undefined);
    get $ref(): StringElement | undefined;
    set $ref($ref: StringElement | undefined);
    get $defs(): ObjectElement | undefined;
    set $defs($defs: ObjectElement | undefined);
    get $comment(): StringElement | undefined;
    set $comment($comment: StringElement | undefined);
    /**
     * Applicator vocabulary
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/applicator
     */
    get allOf(): ArrayElement | undefined;
    set allOf(allOf: ArrayElement | undefined);
    get anyOf(): ArrayElement | undefined;
    set anyOf(anyOf: ArrayElement | undefined);
    get oneOf(): ArrayElement | undefined;
    set oneOf(oneOf: ArrayElement | undefined);
    get not(): Schema | undefined;
    set not(not: Schema | undefined);
    get if(): Schema | undefined;
    set if(ifSchema: Schema | undefined);
    get then(): Schema | undefined;
    set then(thenSchema: Schema | undefined);
    get else(): Schema | undefined;
    set else(elseSchema: Schema | undefined);
    get dependentSchemas(): ObjectElement | undefined;
    set dependentSchemas(dependentSchemas: ObjectElement | undefined);
    get prefixItems(): ArrayElement | undefined;
    set prefixItems(prefixItems: ArrayElement | undefined);
    get items(): Schema | undefined;
    set items(items: Schema | undefined);
    get containsProp(): Schema | undefined;
    set containsProp(containsProp: Schema | undefined);
    get properties(): ObjectElement | undefined;
    set properties(properties: ObjectElement | undefined);
    get patternProperties(): ObjectElement | undefined;
    set patternProperties(patternProperties: ObjectElement | undefined);
    get additionalProperties(): Schema | undefined;
    set additionalProperties(additionalProperties: Schema | undefined);
    get propertyNames(): Schema | undefined;
    set propertyNames(propertyNames: Schema | undefined);
    /**
     * Unevaluated Locations vocabulary
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/unevaluated
     */
    get unevaluatedItems(): Schema | undefined;
    set unevaluatedItems(unevaluatedItems: Schema | undefined);
    get unevaluatedProperties(): Schema | undefined;
    set unevaluatedProperties(unevaluatedProperties: Schema | undefined);
    /**
     * Validation vocabulary
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/validation
     */
    /**
     *  Validation Keywords for Any Instance Type
     *
     *  URI: https://json-schema.org/draft/2020-12/json-schema-validation.html#rfc.section.6.1
     */
    get type(): ArrayElement | StringElement | undefined;
    set type(type: ArrayElement | StringElement | undefined);
    get enum(): ArrayElement | undefined;
    set enum(enumVal: ArrayElement | undefined);
    get const(): Element | undefined;
    set const(constVal: Element | undefined);
    /**
     * Validation Keywords for Numeric Instances (number and integer)
     *
     * URI: https://json-schema.org/draft/2020-12/json-schema-validation.html#numeric
     */
    get multipleOf(): NumberElement | undefined;
    set multipleOf(multipleOf: NumberElement | undefined);
    get maximum(): NumberElement | undefined;
    set maximum(maximum: NumberElement | undefined);
    get exclusiveMaximum(): NumberElement | undefined;
    set exclusiveMaximum(exclusiveMaximum: NumberElement | undefined);
    get minimum(): NumberElement | undefined;
    set minimum(minimum: NumberElement | undefined);
    get exclusiveMinimum(): NumberElement | undefined;
    set exclusiveMinimum(exclusiveMinimum: NumberElement | undefined);
    /**
     * Validation Keywords for Strings
     *
     * URI: https://json-schema.org/draft/2020-12/json-schema-validation.html#string
     */
    get maxLength(): NumberElement | undefined;
    set maxLength(maxLength: NumberElement | undefined);
    get minLength(): NumberElement | undefined;
    set minLength(minLength: NumberElement | undefined);
    get pattern(): StringElement | undefined;
    set pattern(pattern: StringElement | undefined);
    /**
     * Validation Keywords for Arrays
     *
     * URI: https://json-schema.org/draft/2020-12/json-schema-validation.html#rfc.section.6.4
     */
    get maxItems(): NumberElement | undefined;
    set maxItems(maxItems: NumberElement | undefined);
    get minItems(): NumberElement | undefined;
    set minItems(minItems: NumberElement | undefined);
    get uniqueItems(): BooleanElement | undefined;
    set uniqueItems(uniqueItems: BooleanElement | undefined);
    get maxContains(): NumberElement | undefined;
    set maxContains(maxContains: NumberElement | undefined);
    get minContains(): NumberElement | undefined;
    set minContains(minContains: NumberElement | undefined);
    /**
     * Validation Keywords for Objects
     *
     * URI: https://json-schema.org/draft/2020-12/json-schema-validation.html#rfc.section.6.5
     */
    get maxProperties(): NumberElement | undefined;
    set maxProperties(maxProperties: NumberElement | undefined);
    get minProperties(): NumberElement | undefined;
    set minProperties(minProperties: NumberElement | undefined);
    get required(): ArrayElement | undefined;
    set required(required: ArrayElement | undefined);
    get dependentRequired(): ObjectElement | undefined;
    set dependentRequired(dependentRequired: ObjectElement | undefined);
    /**
     * Vocabulary for Basic Meta-Data Annotations
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/meta-data
     */
    get title(): StringElement | undefined;
    set title(title: StringElement | undefined);
    get description(): StringElement | undefined;
    set description(description: StringElement | undefined);
    get default(): Element | undefined;
    set default(defaultVal: Element | undefined);
    get deprecated(): BooleanElement | undefined;
    set deprecated(deprecated: BooleanElement | undefined);
    get readOnly(): BooleanElement | undefined;
    set readOnly(readOnly: BooleanElement | undefined);
    get writeOnly(): BooleanElement | undefined;
    set writeOnly(writeOnly: BooleanElement | undefined);
    get examples(): ArrayElement | undefined;
    set examples(examples: ArrayElement | undefined);
    /**
     * Vocabularies for Semantic Content With "format"
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/format-annotation
     */
    get format(): StringElement | undefined;
    set format(format: StringElement | undefined);
    /**
     * Vocabulary for the Contents of String-Encoded Data
     *
     * URI: https://json-schema.org/draft/2020-12/vocab/content
     */
    get contentEncoding(): StringElement | undefined;
    set contentEncoding(contentEncoding: StringElement | undefined);
    get contentMediaType(): StringElement | undefined;
    set contentMediaType(contentMediaType: StringElement | undefined);
    get contentSchema(): Schema | undefined;
    set contentSchema(contentSchema: Schema | undefined);
    /**
     * OAS base vocabulary
     *
     * URI: https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.1.0.md#baseVocabulary
     */
    get discriminator(): Discriminator | undefined;
    set discriminator(discriminator: Discriminator | undefined);
    get xml(): Xml | undefined;
    set xml(xml: Xml | undefined);
    get externalDocs(): ExternalDocumentation | undefined;
    set externalDocs(externalDocs: ExternalDocumentation | undefined);
    /**
     * @deprecated The example property has been deprecated in favor of the JSON Schema examples keyword. Use of example is discouraged, and later versions of this specification may remove it.
     */
    get example(): Element | undefined;
    set example(example: Element | undefined);
}

declare class Parameter extends ParameterElement {
    get schema(): Schema | undefined;
    set schema(schema: Schema | undefined);
}

/**
 * Override of Schema.example and Schema.examples field inside the Parameter Objects.
 *
 * Parameter Object has two fixed fields:
 *  - `example` of type `Any`
 *  - `examples` of type `Map[string, Example Object | Reference Object]`
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * The example value SHALL override the example provided by the schema.
 * Furthermore, if referencing a schema that contains an example, the examples value SHALL override the example provided by the schema.
 */
declare const plugin$1: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        ParameterElement: {
            leave(parameterElement: Parameter, key: any, parent: any, path: any, ancestors: any[]): void;
        };
    };
};

declare class Header extends HeaderElement {
    get schema(): Schema | undefined;
    set schema(schema: Schema | undefined);
}

/**
 * Override of Schema.example and Schema.examples field inside the Header Objects.
 *
 * Header Object has two fixed fields:
 *  - `example` of type `Any`
 *  - `examples` of type `Map[string, Example Object | Reference Object]`
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * The example value SHALL override the example provided by the schema.
 * Furthermore, if referencing a schema that contains an example, the examples value SHALL override the example provided by the schema.
 */
declare const plugin: () => ({ predicates }: {
    predicates: Predicates;
}) => {
    visitor: {
        HeaderElement: {
            leave(headerElement: Header, key: any, parent: any, path: any, ancestors: any[]): void;
        };
    };
};

declare const isOpenApi3_1LikeElement: <T extends Element>(element: T) => boolean;

declare const getNodeType: <T extends Element>(element: T) => string | undefined;
/**
 * There are unfortunately two `LinkElement` types. One is from base namespace
 * and the other one if from this namespace. `LinkElement` from base namespace
 * is used extremely rarely so it's almost always safe during traversing
 * to assume that `LinkElement` is element from this namespace.
 *
 * To be 100% sure that currently visiting `LinkElement` is from this namespace
 * use `isLinkElement` predicate from this namespace to assert for it.
 */
declare const keyMap: {
    ObjectElement: string[];
    ArrayElement: string[];
    MemberElement: string[];
    StringElement: never[];
    BooleanElement: never[];
    NumberElement: never[];
    NullElement: never[];
    RefElement: never[];
    LinkElement: never[];
    Annotation: never[];
    Comment: never[];
    ParseResultElement: string[];
    SourceMap: string[];
    CallbackElement: string[];
    ComponentsElement: string[];
    ContactElement: string[];
    DiscriminatorElement: string[];
    Encoding: string[];
    Example: string[];
    ExternalDocumentationElement: string[];
    HeaderElement: string[];
    InfoElement: string[];
    LicenseElement: string[];
    MediaTypeElement: string[];
    OAuthFlowElement: string[];
    OAuthFlowsElement: string[];
    OpenApi3_1Element: string[];
    OperationElement: string[];
    ParameterElement: string[];
    PathItemElement: string[];
    PathsElement: string[];
    ReferenceElement: string[];
    RequestBodyElement: string[];
    ResponseElement: string[];
    ResponsesElement: string[];
    SchemaElement: string[];
    SecurityRequirementElement: string[];
    SecuritySchemeElement: string[];
    ServerElement: string[];
    ServerVariableElement: string[];
    TagElement: string[];
};

declare class Callback extends CallbackElement {
}

declare class Contact extends ContactElement {
}

declare class Encoding extends EncodingElement {
}

declare class Example extends ExampleElement {
}

declare class JsonSchemaDialect extends StringElement {
    static default: JsonSchemaDialect;
    constructor(content?: string, meta?: Meta, attributes?: Attributes);
}

declare class MediaType extends MediaTypeElement {
    get schema(): Schema | undefined;
    set schema(schema: Schema | undefined);
}

declare class OAuthFlow extends OAuthFlowElement {
}

declare class OAuthFlows extends OAuthFlowsElement {
}

declare class Response extends ResponseElement {
}

declare class Responses extends ResponsesElement {
}

declare class SecurityRequirement extends SecurityRequirementElement {
}

declare class SecurityScheme extends SecuritySchemeElement {
}

declare class Server extends ServerElement {
}

declare class ServerVariable extends ServerVariableElement {
}

declare class Tag extends TagElement {
}

declare class ComponentsPathItems extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

declare class Webhooks extends ObjectElement {
    static primaryClass: string;
    constructor(content?: Record<string, unknown>, meta?: Meta, attributes?: Attributes);
}

export { Callback as CallbackElement, Components as ComponentsElement, ComponentsPathItems as ComponentsPathItemsElement, Contact as ContactElement, Discriminator as DiscriminatorElement, Encoding as EncodingElement, Example as ExampleElement, ExternalDocumentation as ExternalDocumentationElement, Header as HeaderElement, Info as InfoElement, JsonSchemaDialect as JsonSchemaDialectElement, License as LicenseElement, Link as LinkElement, MediaType as MediaTypeElement, OAuthFlow as OAuthFlowElement, OAuthFlows as OAuthFlowsElement, OpenAPIMediaTypes, OpenApi3_1 as OpenApi3_1Element, Openapi as OpenapiElement, Operation as OperationElement, Parameter as ParameterElement, PathItem as PathItemElement, Paths as PathsElement, Reference as ReferenceElement, RequestBody as RequestBodyElement, Response as ResponseElement, Responses as ResponsesElement, Schema as SchemaElement, SecurityRequirement as SecurityRequirementElement, SecurityScheme as SecuritySchemeElement, Server as ServerElement, ServerVariable as ServerVariableElement, Tag as TagElement, Webhooks as WebhooksElement, Xml as XmlElement, createToolbox, openApi3_1 as default, getNodeType, isBooleanJsonSchemaElement, isCallbackElement, isComponentsElement, isContactElement, isExampleElement, isExternalDocumentationElement, isInfoElement, isJsonSchemaDialectElement, isLicenseElement, isLinkElement, isLinkElementExternal, isMediaTypeElement, isOpenApi3_1Element, isOpenApi3_1LikeElement, isOpenapiElement, isOperationElement, isParameterElement, isPathItemElement, isPathItemElementExternal, isPathsElement, isReferenceElement, isReferenceElementExternal, isRequestBodyElement, isResponseElement, isResponsesElement, isSchemaElement, isSecurityRequirementElement, isServerElement, isServerVariableElement, keyMap, mediaTypes, plugin as refractorPluginNormalizeHeaderExamples, plugin$2 as refractorPluginNormalizeOperationIds, plugin$1 as refractorPluginNormalizeParameterExamples, plugin$5 as refractorPluginNormalizeParameters, plugin$4 as refractorPluginNormalizeSecurityRequirements, plugin$3 as refractorPluginNormalizeServers, plugin$6 as refractorPluginReplaceEmptyElement };
