"use strict";

exports.__esModule = true;
exports.default = void 0;
/**
 * Override of Schema.example and Schema.examples field inside the Parameter Objects.
 *
 * Parameter Object has two fixed fields:
 *  - `example` of type `Any`
 *  - `examples` of type `Map[string, Example Object | Reference Object]`
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * The example value SHALL override the example provided by the schema.
 * Furthermore, if referencing a schema that contains an example, the examples value SHALL override the example provided by the schema.
 */
/* eslint-disable no-param-reassign */
const plugin = () => ({
  predicates
}) => {
  return {
    visitor: {
      ParameterElement: {
        leave(parameterElement, key, parent, path, ancestors) {
          var _parameterElement$sch, _parameterElement$sch2;
          // skip visiting this Parameter Object
          if (ancestors.some(predicates.isComponentsElement)) {
            return;
          }

          // no Parameter.schema field present
          if (typeof parameterElement.schema === 'undefined' || !predicates.isSchemaElement(parameterElement.schema)) {
            return;
          }
          // Schema contains no example
          if (typeof ((_parameterElement$sch = parameterElement.schema) === null || _parameterElement$sch === void 0 ? void 0 : _parameterElement$sch.example) === 'undefined' && typeof ((_parameterElement$sch2 = parameterElement.schema) === null || _parameterElement$sch2 === void 0 ? void 0 : _parameterElement$sch2.examples) === 'undefined') {
            return;
          }

          /**
           * Parameter.examples and Schema.examples have preferences over the older
           * and deprected `example` field.
           */
          if (typeof parameterElement.examples !== 'undefined' && predicates.isObjectElement(parameterElement.examples)) {
            // @ts-ignore
            const examples = parameterElement.examples.map(example => {
              var _example$value;
              return (_example$value = example.value) === null || _example$value === void 0 ? void 0 : _example$value.clone();
            });
            if (typeof parameterElement.schema.examples !== 'undefined') {
              parameterElement.schema.set('examples', examples);
            }
            if (typeof parameterElement.schema.example !== 'undefined') {
              parameterElement.schema.set('example', examples);
            }
            return;
          }

          /**
           * Handle deprecated `example` field.
           */
          if (typeof parameterElement.example !== 'undefined') {
            if (typeof parameterElement.schema.examples !== 'undefined') {
              parameterElement.schema.set('examples', [parameterElement.example.clone()]);
            }
            if (typeof parameterElement.schema.example !== 'undefined') {
              parameterElement.schema.set('example', parameterElement.example.clone());
            }
          }
        }
      }
    }
  };
};
/* eslint-enable */
var _default = plugin;
exports.default = _default;