"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
/**
 * Override of Security Requirement Objects.
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * Operation.security definition overrides any declared top-level security.
 * To remove a top-level security declaration, an empty array can be used.
 * When a list of Security Requirement Objects is defined on the OpenAPI Object or Operation Object,
 * only one of the Security Requirement Objects in the list needs to be satisfied to authorize the request.
 */
/* eslint-disable no-param-reassign */
const plugin = () => ({
  predicates
}) => {
  let topLevelSecurity;
  return {
    visitor: {
      OpenApi3_1Element: {
        enter(openapiElement) {
          if (predicates.isArrayElement(openapiElement.security)) {
            topLevelSecurity = openapiElement.security;
          }
        },
        leave() {
          topLevelSecurity = undefined;
        }
      },
      OperationElement: {
        leave(operationElement, key, parent, path, ancestors) {
          // skip visiting this Operation
          if (ancestors.some(predicates.isComponentsElement)) {
            return;
          }
          const missingOperationLevelSecurity = typeof operationElement.security === 'undefined';
          const hasTopLevelSecurity = typeof topLevelSecurity !== 'undefined';
          if (missingOperationLevelSecurity && hasTopLevelSecurity) {
            var _topLevelSecurity;
            operationElement.security = new _apidomNsOpenapi.OperationSecurityElement((_topLevelSecurity = topLevelSecurity) === null || _topLevelSecurity === void 0 ? void 0 : _topLevelSecurity.content);
          }
        }
      }
    }
  };
};
/* eslint-enable */
var _default = plugin;
exports.default = _default;