"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
var _Webhooks = _interopRequireDefault(require("../../../elements/nces/Webhooks.cjs"));
var _predicates = require("../../../predicates.cjs");
const WebhooksVisitor = (0, _stampit.default)(_apidomNsOpenapi.MapVisitor, _apidomNsOpenapi.FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return (0, _apidomNsOpenapi.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new _Webhooks.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _apidomNsOpenapi.MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(_predicates.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });

      // decorate every PathItemElement with Webhook name metadata
      this.element.filter(_predicates.isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('webhook-name', key.toValue());
      });
      return result;
    }
  }
});
var _default = WebhooksVisitor;
exports.default = _default;