"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
var _Callback = _interopRequireDefault(require("../../../../elements/Callback.cjs"));
var _predicates = require("../../../../predicates.cjs");
const {
  visitors: {
    document: {
      objects: {
        Callback: {
          $visitor: BaseCallbackVisitor
        }
      }
    }
  }
} = _apidomNsOpenapi.specificationObj;
const CallbackVisitor = (0, _stampit.default)(BaseCallbackVisitor, {
  props: {
    specPath: element => {
      return (0, _apidomNsOpenapi.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new _Callback.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = BaseCallbackVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(_predicates.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });
      return result;
    }
  }
});
var _default = CallbackVisitor;
exports.default = _default;