import stampit from 'stampit';
import { isReferenceLikeElement, MapVisitor, FallbackVisitor } from '@swagger-api/apidom-ns-openapi-3-0';
import WebhooksElement from "../../../elements/nces/Webhooks.js";
import { isPathItemElement, isReferenceElement } from "../../../predicates.js";
const WebhooksVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new WebhooksElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });

      // decorate every PathItemElement with Webhook name metadata
      this.element.filter(isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('webhook-name', key.toValue());
      });
      return result;
    }
  }
});
export default WebhooksVisitor;