import stampit from 'stampit';
import { isReferenceLikeElement, specificationObj as OpenApi3_1Specification } from '@swagger-api/apidom-ns-openapi-3-0';
import CallbackElement from "../../../../elements/Callback.js";
import { isReferenceElement } from "../../../../predicates.js";
const {
  visitors: {
    document: {
      objects: {
        Callback: {
          $visitor: BaseCallbackVisitor
        }
      }
    }
  }
} = OpenApi3_1Specification;
const CallbackVisitor = stampit(BaseCallbackVisitor, {
  props: {
    specPath: element => {
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
    }
  },
  init() {
    this.element = new CallbackElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = BaseCallbackVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'pathItem');
      });
      return result;
    }
  }
});
export default CallbackVisitor;