"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
const ReferenceSet = (0, _stampit.default)({
  props: {
    rootRef: null,
    refs: [],
    circular: false
  },
  init({
    refs = []
  } = {}) {
    this.refs = [];
    refs.forEach(ref => this.add(ref));
  },
  methods: {
    get size() {
      // @ts-ignore
      return this.refs.length;
    },
    add(reference) {
      if (!this.has(reference)) {
        this.refs.push(reference);
        this.rootRef = this.rootRef === null ? reference : this.rootRef;
        reference.refSet = this; // eslint-disable-line no-param-reassign
      }

      return this;
    },
    merge(anotherRefSet) {
      for (const reference of anotherRefSet.values()) {
        this.add(reference);
      }
      return this;
    },
    has(thing) {
      const uri = (0, _ramdaAdjunct.isString)(thing) ? thing : thing.uri;
      return (0, _ramdaAdjunct.isNotUndefined)(this.find((0, _ramda.propEq)('uri', uri)));
    },
    find(callback) {
      return this.refs.find(callback);
    },
    *values() {
      yield* this.refs;
    },
    clean() {
      this.refs.forEach(ref => {
        // eslint-disable-next-line no-param-reassign
        ref.refSet = null;
      });
      this.refs = [];
    }
  }
});
var _default = ReferenceSet;
exports.default = _default;