"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.dereferenceApiDOM = exports.default = void 0;
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _File = _interopRequireDefault(require("../util/File.cjs"));
var plugins = _interopRequireWildcard(require("../util/plugins.cjs"));
var _index = require("../util/errors/index.cjs");
var _DereferenceError = _interopRequireDefault(require("../util/errors/DereferenceError.cjs"));
var _index2 = _interopRequireDefault(require("../parse/index.cjs"));
var _util = require("../options/util.cjs");
var url = _interopRequireWildcard(require("../util/url.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Dereferences ApiDOM with all its external references.
 */
const dereferenceApiDOM = async (element, options) => {
  // @ts-ignore
  let parseResult = element;
  let surrogateWrapping = false;

  // wrap element into parse result
  if (!(0, _apidomCore.isParseResultElement)(element)) {
    // shallow clone of the element
    // @ts-ignore
    const elementClone = new element.constructor(element.content, element.meta.clone(), element.attributes);
    elementClone.classes.push('result');
    parseResult = new _apidomCore.ParseResultElement([elementClone]);
    surrogateWrapping = true;
  }
  const file = (0, _File.default)({
    uri: options.resolve.baseURI,
    parseResult,
    mediaType: options.parse.mediaType
  });
  const dereferenceStrategies = await plugins.filter('canDereference', file, options.dereference.strategies);

  // we couldn't find any dereference for this File
  if ((0, _ramda.isEmpty)(dereferenceStrategies)) {
    throw new _index.UnmatchedDereferenceStrategyError(file.uri);
  }
  try {
    const {
      result
    } = await plugins.run('dereference', [file, options], dereferenceStrategies);
    // unwrap the element from ParseResult assuming first element is the actual result
    return surrogateWrapping ? result.get(0) : result;
  } catch (error) {
    throw new _DereferenceError.default(`Error while dereferencing file "${file.uri}"`, {
      cause: error
    });
  }
};

/**
 * Dereferences a file with all its external references.
 */
exports.dereferenceApiDOM = dereferenceApiDOM;
const dereference = async (uri, options) => {
  const {
    refSet
  } = options.dereference;
  const sanitizedURI = url.sanitize(uri);
  let parseResult;

  // if refSet was provided, use it to avoid unnecessary parsing
  if (refSet !== null && refSet.has(sanitizedURI)) {
    // @ts-ignore
    ({
      value: parseResult
    } = refSet.find((0, _ramda.propEq)('uri', sanitizedURI)));
  } else {
    parseResult = await (0, _index2.default)(uri, options);
  }
  const mergedOptions = (0, _util.merge)(options, {
    resolve: {
      baseURI: sanitizedURI
    }
  });
  return dereferenceApiDOM(parseResult, mergedOptions);
};
var _default = dereference;
exports.default = _default;