"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsAsyncapi = _interopRequireWildcard(require("@swagger-api/apidom-ns-asyncapi-2"));
var _DereferenceStrategy = _interopRequireDefault(require("../DereferenceStrategy.cjs"));
var _Reference = _interopRequireDefault(require("../../../Reference.cjs"));
var _ReferenceSet = _interopRequireDefault(require("../../../ReferenceSet.cjs"));
var _visitor = _interopRequireDefault(require("./visitor.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// @ts-ignore
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];
const AsyncApi2DereferenceStrategy = (0, _stampit.default)(_DereferenceStrategy.default, {
  init() {
    this.name = 'asyncapi-2';
  },
  methods: {
    canDereference(file) {
      var _file$parseResult;
      // assert by media type
      if (file.mediaType !== 'text/plain') {
        return _apidomNsAsyncapi.mediaTypes.includes(file.mediaType);
      }

      // assert by inspecting ApiDOM
      return (0, _apidomNsAsyncapi.isAsyncApi2Element)((_file$parseResult = file.parseResult) === null || _file$parseResult === void 0 ? void 0 : _file$parseResult.api);
    },
    async dereference(file, options) {
      const namespace = (0, _apidomCore.createNamespace)(_apidomNsAsyncapi.default);
      const refSet = (0, _ramda.defaultTo)((0, _ReferenceSet.default)(), options.dereference.refSet);
      let reference;
      if (!refSet.has(file.uri)) {
        reference = (0, _Reference.default)({
          uri: file.uri,
          value: file.parseResult
        });
        refSet.add(reference);
      } else {
        // pre-computed refSet was provided as configuration option
        reference = refSet.find((0, _ramda.propEq)('uri', file.uri));
      }
      const visitor = (0, _visitor.default)({
        reference,
        namespace,
        options
      });
      const dereferencedElement = await visitAsync(refSet.rootRef.value, visitor, {
        keyMap: _apidomNsAsyncapi.keyMap,
        nodeTypeGetter: _apidomNsAsyncapi.getNodeType
      });

      /**
       * Release all memory if this refSet was not provided as an configuration option.
       * If provided as configuration option, then provider is responsible for cleanup.
       */
      if (options.dereference.refSet === null) {
        refSet.clean();
      }
      return dereferencedElement;
    }
  }
});
var _default = AsyncApi2DereferenceStrategy;
exports.default = _default;