"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomJsonPointer = require("@swagger-api/apidom-json-pointer");
var _apidomNsAsyncapi = require("@swagger-api/apidom-ns-asyncapi-2");
var _index = require("../../../util/errors/index.cjs");
var url = _interopRequireWildcard(require("../../../util/url.cjs"));
var _index2 = _interopRequireDefault(require("../../../parse/index.cjs"));
var _Reference = _interopRequireDefault(require("../../../Reference.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// @ts-ignore
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];
const AsyncApi2DereferenceVisitor = (0, _stampit.default)({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    options: null,
    ancestors: null
  },
  init({
    indirections = [],
    reference,
    namespace,
    options,
    ancestors = []
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.options = options;
    this.ancestors = [...ancestors];
  },
  methods: {
    toAncestorLineage(ancestors) {
      /**
       * Compute full ancestors lineage.
       * Ancestors are flatten to unwrap all Element instances.
       */
      const directAncestors = new WeakSet(ancestors.flat());
      const ancestorsLineage = [...this.ancestors, directAncestors];
      return [ancestorsLineage, directAncestors];
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new _index.MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find((0, _ramda.propEq)('uri', baseURI));
      }
      const parseResult = await (0, _index2.default)(url.unsanitize(baseURI), {
        ...this.options,
        parse: {
          ...this.options.parse,
          mediaType: 'text/plain'
        }
      });

      // register new Reference with ReferenceSet
      const reference = (0, _Reference.default)({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    async ReferenceElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$, _referencingElement$$2, _referencingElement$$3;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && (0, _apidomNsAsyncapi.isReferenceElementExternal)(referencingElement)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }

      // @ts-ignore
      const reference = await this.toReference((_referencingElement$$ = referencingElement.$ref) === null || _referencingElement$$ === void 0 ? void 0 : _referencingElement$$.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$2 = referencingElement.$ref) === null || _referencingElement$$2 === void 0 ? void 0 : _referencingElement$$2.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
        const referencedElementType = referencingElement.meta.get('referenced-element').toValue();
        if ((0, _apidomNsAsyncapi.isReferenceLikeElement)(referencedElement)) {
          // handling indirect references
          referencedElement = _apidomNsAsyncapi.ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _index.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the fragment
      const visitor = AsyncApi2DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap: _apidomNsAsyncapi.keyMap,
        nodeTypeGetter: _apidomNsAsyncapi.getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // @ts-ignore
      referencedElement = new referencedElement.constructor(
      // shallow clone of the referenced element
      referencedElement.content, referencedElement.meta.clone(), referencedElement.attributes.clone());

      // annotate referenced element with info about original referencing element
      referencedElement.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$3 = referencingElement.$ref) === null || _referencingElement$$3 === void 0 ? void 0 : _referencingElement$$3.toValue()
      });
      // annotate fragment with info about origin
      referencedElement.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return referencedElement;
    },
    async ChannelItemElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$4, _referencingElement$$5, _referencingElement$$6;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // ignore ChannelItemElement without $ref field
      if (!(0, _apidomCore.isStringElement)(referencingElement.$ref)) {
        return undefined;
      }

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external ChannelItem Elements
      if (!this.options.resolve.external && (0, _apidomNsAsyncapi.isChannelItemElementExternal)(referencingElement)) {
        return undefined;
      }
      const reference = await this.toReference((_referencingElement$$4 = referencingElement.$ref) === null || _referencingElement$$4 === void 0 ? void 0 : _referencingElement$$4.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$5 = referencingElement.$ref) === null || _referencingElement$$5 === void 0 ? void 0 : _referencingElement$$5.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

      // applying semantics to a referenced element
      if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
        referencedElement = _apidomNsAsyncapi.ChannelItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Channel Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _index.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing channel item to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the referenced element
      const visitor = AsyncApi2DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap: _apidomNsAsyncapi.keyMap,
        nodeTypeGetter: _apidomNsAsyncapi.getNodeType
      });

      // remove referencing channel item from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // merge fields from referenced Channel Item with referencing one
      const mergedResult = new _apidomNsAsyncapi.ChannelItemElement(
      // @ts-ignore
      [...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
      // existing keywords from referencing ChannelItemElement overrides ones from referenced ChannelItemElement
      referencingElement.forEach((value, keyElement, item) => {
        mergedResult.remove(keyElement.toValue());
        mergedResult.content.push(item);
      });
      mergedResult.remove('$ref');

      // annotate referenced element with info about original referencing element
      mergedResult.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$6 = referencingElement.$ref) === null || _referencingElement$$6 === void 0 ? void 0 : _referencingElement$$6.toValue()
      });
      // annotate referenced with info about origin
      mergedResult.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return mergedResult;
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      const [ancestorsLineage] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }
      return undefined;
    }
  }
});
var _default = AsyncApi2DereferenceVisitor;
exports.default = _default;