"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _buffer = require("#buffer");
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _index = require("../../../util/errors/index.cjs");
var _Parser = _interopRequireDefault(require("../Parser.cjs"));
// eslint-disable-line import/order

/**
 * Everything that is not recognized by other parsers will be considered by this parser
 * as a binary data and will be encoded to Base64 format.
 */

const BinaryParser = (0, _stampit.default)(_Parser.default, {
  props: {
    name: 'binary'
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      return hasSupportedFileExtension;
    },
    async parse(file) {
      let base64String;
      try {
        // @ts-ignore
        base64String = _buffer.Buffer.from(file.data).toString('base64');
      } catch {
        base64String = _buffer.Buffer.from(file.toString()).toString('base64');
      }
      try {
        const parseResultElement = new _apidomCore.ParseResultElement();
        if (base64String.length !== 0) {
          const base64StringElement = new _apidomCore.StringElement(base64String);
          base64StringElement.classes.push('result');
          parseResultElement.push(base64StringElement);
        }
        return parseResultElement;
      } catch (error) {
        throw new _index.ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = BinaryParser;
exports.default = _default;