"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomParserAdapterYaml = require("@swagger-api/apidom-parser-adapter-yaml-1-2");
var _index = require("../../../util/errors/index.cjs");
var _Parser = _interopRequireDefault(require("../Parser.cjs"));
const YamlParser = (0, _stampit.default)(_Parser.default, {
  props: {
    name: 'yaml-1-2',
    fileExtensions: ['.yaml', '.yml'],
    mediaTypes: _apidomParserAdapterYaml.mediaTypes
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        return (0, _apidomParserAdapterYaml.detect)(file.toString());
      }
      return false;
    },
    async parse(file) {
      const source = file.toString();
      try {
        return await (0, _apidomParserAdapterYaml.parse)(source, {
          sourceMap: this.sourceMap
        });
      } catch (error) {
        throw new _index.ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = YamlParser;
exports.default = _default;