"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomJsonPointer = require("@swagger-api/apidom-json-pointer");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-0");
var _index = require("../../../util/errors/index.cjs");
var url = _interopRequireWildcard(require("../../../util/url.cjs"));
var _index2 = _interopRequireDefault(require("../../../parse/index.cjs"));
var _Reference = _interopRequireDefault(require("../../../Reference.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// @ts-ignore
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_0ResolveVisitor = (0, _stampit.default)({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    crawledElements: null,
    crawlingMap: null,
    options: null
  },
  init({
    reference,
    namespace,
    indirections = [],
    options
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.crawledElements = [];
    this.crawlingMap = {};
    this.options = options;
  },
  methods: {
    toBaseURI(uri) {
      return url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new _index.MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = this.toBaseURI(uri);
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find((0, _ramda.propEq)('uri', baseURI));
      }
      const parseResult = await (0, _index2.default)(url.unsanitize(baseURI), {
        ...this.options,
        parse: {
          ...this.options.parse,
          mediaType: 'text/plain'
        }
      });

      // register new Reference with ReferenceSet
      const reference = (0, _Reference.default)({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    ReferenceElement(referenceElement) {
      var _referenceElement$$re;
      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && (0, _apidomNsOpenapi.isReferenceElementExternal)(referenceElement)) {
        return false;
      }
      const uri = (_referenceElement$$re = referenceElement.$ref) === null || _referenceElement$$re === void 0 ? void 0 : _referenceElement$$re.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!(0, _ramda.has)(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(referenceElement);
      return undefined;
    },
    PathItemElement(pathItemElement) {
      var _pathItemElement$$ref;
      // ignore PathItemElement without $ref field
      if (!(0, _apidomCore.isStringElement)(pathItemElement.$ref)) {
        return undefined;
      }

      // ignore resolving external Path Item Objects
      if (!this.options.resolve.external && (0, _apidomNsOpenapi.isPathItemElementExternal)(pathItemElement)) {
        return undefined;
      }
      const uri = (_pathItemElement$$ref = pathItemElement.$ref) === null || _pathItemElement$$ref === void 0 ? void 0 : _pathItemElement$$ref.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!(0, _ramda.has)(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(pathItemElement);
      return undefined;
    },
    LinkElement(linkElement) {
      // ignore LinkElement without operationRef or operationId field
      if (!(0, _apidomCore.isStringElement)(linkElement.operationRef) && !(0, _apidomCore.isStringElement)(linkElement.operationId)) {
        return undefined;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && (0, _apidomNsOpenapi.isLinkElementExternal)(linkElement)) {
        return undefined;
      }

      // operationRef and operationId are mutually exclusive
      if ((0, _apidomCore.isStringElement)(linkElement.operationRef) && (0, _apidomCore.isStringElement)(linkElement.operationId)) {
        throw new Error('LinkElement operationRef and operationId are mutually exclusive.');
      }
      if ((0, _apidomNsOpenapi.isLinkElementExternal)(linkElement)) {
        var _linkElement$operatio;
        const uri = (_linkElement$operatio = linkElement.operationRef) === null || _linkElement$operatio === void 0 ? void 0 : _linkElement$operatio.toValue();
        const baseURI = this.toBaseURI(uri);
        if (!(0, _ramda.has)(baseURI, this.crawlingMap)) {
          this.crawlingMap[baseURI] = this.toReference(uri);
        }
      }
      return undefined;
    },
    ExampleElement(exampleElement) {
      var _exampleElement$exter;
      // ignore ExampleElement without externalValue field
      if (!(0, _apidomCore.isStringElement)(exampleElement.externalValue)) {
        return undefined;
      }

      // ignore resolving ExampleElement externalValue
      if (!this.options.resolve.external && (0, _apidomCore.isStringElement)(exampleElement.externalValue)) {
        return undefined;
      }

      // value and externalValue fields are mutually exclusive
      if (exampleElement.hasKey('value') && (0, _apidomCore.isStringElement)(exampleElement.externalValue)) {
        throw new Error('ExampleElement value and externalValue fields are mutually exclusive.');
      }
      const uri = (_exampleElement$exter = exampleElement.externalValue) === null || _exampleElement$exter === void 0 ? void 0 : _exampleElement$exter.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!(0, _ramda.has)(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      return undefined;
    },
    async crawlReferenceElement(referenceElement) {
      var _referenceElement$$re2;
      // @ts-ignore
      const reference = await this.toReference(referenceElement.$ref.toValue());
      this.indirections.push(referenceElement);
      const jsonPointer = (0, _apidomJsonPointer.uriToPointer)((_referenceElement$$re2 = referenceElement.$ref) === null || _referenceElement$$re2 === void 0 ? void 0 : _referenceElement$$re2.toValue());

      // possibly non-semantic fragment
      let fragment = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if ((0, _apidomCore.isPrimitiveElement)(fragment)) {
        const referencedElementType = referenceElement.meta.get('referenced-element').toValue();
        if ((0, _apidomNsOpenapi.isReferenceLikeElement)(fragment)) {
          // handling indirect references
          fragment = _apidomNsOpenapi.ReferenceElement.refract(fragment);
          fragment.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          fragment = ElementClass.refract(fragment);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(fragment)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _index.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the fragment
      const visitor = OpenApi3_0ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(fragment, visitor, {
        keyMap: _apidomNsOpenapi.keyMap,
        nodeTypeGetter: _apidomNsOpenapi.getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawlPathItemElement(pathItemElement) {
      var _pathItemElement$$ref2, _pathItemElement$$ref3;
      // @ts-ignore
      const reference = await this.toReference((_pathItemElement$$ref2 = pathItemElement.$ref) === null || _pathItemElement$$ref2 === void 0 ? void 0 : _pathItemElement$$ref2.toValue());
      this.indirections.push(pathItemElement);
      const jsonPointer = (0, _apidomJsonPointer.uriToPointer)((_pathItemElement$$ref3 = pathItemElement.$ref) === null || _pathItemElement$$ref3 === void 0 ? void 0 : _pathItemElement$$ref3.toValue());

      // possibly non-semantic fragment
      let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
        referencedElement = _apidomNsOpenapi.PathItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _index.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the fragment
      const visitor = OpenApi3_0ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(referencedElement, visitor, {
        keyMap: _apidomNsOpenapi.keyMap,
        nodeTypeGetter: _apidomNsOpenapi.getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawl() {
      /**
       * Synchronize all parallel resolutions in this place.
       * After synchronization happened we can be sure that refSet
       * contains resolved Reference objects.
       */
      await (0, _ramda.pipe)(_ramda.values, _ramdaAdjunct.allP)(this.crawlingMap);
      this.crawlingMap = null;

      /* eslint-disable no-await-in-loop */
      for (const element of this.crawledElements) {
        if ((0, _apidomNsOpenapi.isReferenceElement)(element)) {
          await this.crawlReferenceElement(element);
        } else if ((0, _apidomNsOpenapi.isPathItemElement)(element)) {
          await this.crawlPathItemElement(element);
        }
      }
      /* eslint-enabled */
    }
  }
});
var _default = OpenApi3_0ResolveVisitor;
exports.default = _default;