"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var url = _interopRequireWildcard(require("./url.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * This stamp represents a File object with url and data.
 */

const File = (0, _stampit.default)({
  props: {
    uri: null,
    mediaType: 'text/plain',
    data: null,
    parseResult: null
  },
  init({
    uri = this.uri,
    mediaType = this.mediaType,
    data = this.data,
    parseResult = this.parseResult
  } = {}) {
    this.uri = uri;
    this.mediaType = mediaType;
    this.data = data;
    this.parseResult = parseResult;
  },
  methods: {
    get extension() {
      if ((0, _ramdaAdjunct.isString)(this.uri)) {
        return url.getExtension(this.uri);
      }
      return '';
    },
    toString() {
      if (typeof this.data === 'string') {
        return this.data;
      }
      if (this.data instanceof ArrayBuffer || ['ArrayBuffer'].includes((0, _ramda.type)(this.data)) || ArrayBuffer.isView(this.data)) {
        const textDecoder = new TextDecoder('utf-8');
        return textDecoder.decode(this.data);
      }
      return String(this.data);
    }
  }
});
var _default = File;
exports.default = _default;