import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { propEq } from 'ramda';
import { isPrimitiveElement, isStringElement, visit } from '@swagger-api/apidom-core';
import { evaluate, uriToPointer } from '@swagger-api/apidom-json-pointer';
import { getNodeType, isReferenceLikeElement, keyMap, ReferenceElement, ChannelItemElement, isReferenceElementExternal, isChannelItemElementExternal } from '@swagger-api/apidom-ns-asyncapi-2';
import { MaximumDereferenceDepthError, MaximumResolverDepthError } from "../../../util/errors/index.js";
import * as url from "../../../util/url.js";
import parse from "../../../parse/index.js";
import Reference from "../../../Reference.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];
const AsyncApi2DereferenceVisitor = stampit({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    options: null,
    ancestors: null
  },
  init({
    indirections = [],
    reference,
    namespace,
    options,
    ancestors = []
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.options = options;
    this.ancestors = [...ancestors];
  },
  methods: {
    toAncestorLineage(ancestors) {
      /**
       * Compute full ancestors lineage.
       * Ancestors are flatten to unwrap all Element instances.
       */
      const directAncestors = new WeakSet(ancestors.flat());
      const ancestorsLineage = [...this.ancestors, directAncestors];
      return [ancestorsLineage, directAncestors];
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find(propEq('uri', baseURI));
      }
      const parseResult = await parse(url.unsanitize(baseURI), _objectSpread(_objectSpread({}, this.options), {}, {
        parse: _objectSpread(_objectSpread({}, this.options.parse), {}, {
          mediaType: 'text/plain'
        })
      }));

      // register new Reference with ReferenceSet
      const reference = Reference({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    async ReferenceElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$, _referencingElement$$2, _referencingElement$$3;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isReferenceElementExternal(referencingElement)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }

      // @ts-ignore
      const reference = await this.toReference((_referencingElement$$ = referencingElement.$ref) === null || _referencingElement$$ === void 0 ? void 0 : _referencingElement$$.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$2 = referencingElement.$ref) === null || _referencingElement$$2 === void 0 ? void 0 : _referencingElement$$2.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(referencedElement)) {
        const referencedElementType = referencingElement.meta.get('referenced-element').toValue();
        if (isReferenceLikeElement(referencedElement)) {
          // handling indirect references
          referencedElement = ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the fragment
      const visitor = AsyncApi2DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // @ts-ignore
      referencedElement = new referencedElement.constructor(
      // shallow clone of the referenced element
      referencedElement.content, referencedElement.meta.clone(), referencedElement.attributes.clone());

      // annotate referenced element with info about original referencing element
      referencedElement.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$3 = referencingElement.$ref) === null || _referencingElement$$3 === void 0 ? void 0 : _referencingElement$$3.toValue()
      });
      // annotate fragment with info about origin
      referencedElement.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return referencedElement;
    },
    async ChannelItemElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$4, _referencingElement$$5, _referencingElement$$6;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // ignore ChannelItemElement without $ref field
      if (!isStringElement(referencingElement.$ref)) {
        return undefined;
      }

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external ChannelItem Elements
      if (!this.options.resolve.external && isChannelItemElementExternal(referencingElement)) {
        return undefined;
      }
      const reference = await this.toReference((_referencingElement$$4 = referencingElement.$ref) === null || _referencingElement$$4 === void 0 ? void 0 : _referencingElement$$4.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$5 = referencingElement.$ref) === null || _referencingElement$$5 === void 0 ? void 0 : _referencingElement$$5.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a referenced element
      if (isPrimitiveElement(referencedElement)) {
        referencedElement = ChannelItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Channel Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing channel item to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the referenced element
      const visitor = AsyncApi2DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing channel item from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // merge fields from referenced Channel Item with referencing one
      const mergedResult = new ChannelItemElement(
      // @ts-ignore
      [...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
      // existing keywords from referencing ChannelItemElement overrides ones from referenced ChannelItemElement
      referencingElement.forEach((value, keyElement, item) => {
        mergedResult.remove(keyElement.toValue());
        mergedResult.content.push(item);
      });
      mergedResult.remove('$ref');

      // annotate referenced element with info about original referencing element
      mergedResult.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$6 = referencingElement.$ref) === null || _referencingElement$$6 === void 0 ? void 0 : _referencingElement$$6.toValue()
      });
      // annotate referenced with info about origin
      mergedResult.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return mergedResult;
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      const [ancestorsLineage] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }
      return undefined;
    }
  }
});
export default AsyncApi2DereferenceVisitor;