import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { propEq } from 'ramda';
import { isUndefined } from 'ramda-adjunct';
import { isPrimitiveElement, isStringElement, visit, find } from '@swagger-api/apidom-core';
import { evaluate, uriToPointer } from '@swagger-api/apidom-json-pointer';
import { getNodeType, isReferenceLikeElement, keyMap, ReferenceElement, OperationElement, PathItemElement, isOperationElement, isReferenceElementExternal, isPathItemElementExternal, isLinkElementExternal } from '@swagger-api/apidom-ns-openapi-3-0';
import { MaximumDereferenceDepthError, MaximumResolverDepthError } from "../../../util/errors/index.js";
import * as url from "../../../util/url.js";
import parse from "../../../parse/index.js";
import Reference from "../../../Reference.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_0DereferenceVisitor = stampit({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    options: null,
    ancestors: null
  },
  init({
    indirections = [],
    reference,
    namespace,
    options,
    ancestors = []
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.options = options;
    this.ancestors = [...ancestors];
  },
  methods: {
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find(propEq('uri', baseURI));
      }
      const parseResult = await parse(url.unsanitize(baseURI), _objectSpread(_objectSpread({}, this.options), {}, {
        parse: _objectSpread(_objectSpread({}, this.options.parse), {}, {
          mediaType: 'text/plain'
        })
      }));

      // register new Reference with ReferenceSet
      const reference = Reference({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    toAncestorLineage(ancestors) {
      /**
       * Compute full ancestors lineage.
       * Ancestors are flatten to unwrap all Element instances.
       */
      const directAncestors = new WeakSet(ancestors.flat());
      const ancestorsLineage = [...this.ancestors, directAncestors];
      return [ancestorsLineage, directAncestors];
    },
    async ReferenceElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$, _referencingElement$$2;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isReferenceElementExternal(referencingElement)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }
      const reference = await this.toReference((_referencingElement$$ = referencingElement.$ref) === null || _referencingElement$$ === void 0 ? void 0 : _referencingElement$$.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$2 = referencingElement.$ref) === null || _referencingElement$$2 === void 0 ? void 0 : _referencingElement$$2.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(referencedElement)) {
        const referencedElementType = referencingElement.meta.get('referenced-element').toValue();
        if (isReferenceLikeElement(referencedElement)) {
          // handling indirect references
          referencedElement = ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the fragment
      const visitor = OpenApi3_0DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // @ts-ignore
      referencedElement = new referencedElement.constructor(
      // shallow clone of the referenced element
      referencedElement.content, referencedElement.meta.clone(), referencedElement.attributes.clone());

      // annotate referenced element with info about original referencing element
      referencedElement.setMetaProperty('ref-fields', {
        // @ts-ignore
        $ref: referencingElement.$ref.toValue()
      });
      // annotate fragment with info about origin
      referencedElement.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return referencedElement;
    },
    async PathItemElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$3, _referencingElement$$4, _referencingElement$$5;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

      // ignore PathItemElement without $ref field
      if (!isStringElement(referencingElement.$ref)) {
        return undefined;
      }

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isPathItemElementExternal(referencingElement)) {
        return undefined;
      }
      const reference = await this.toReference((_referencingElement$$3 = referencingElement.$ref) === null || _referencingElement$$3 === void 0 ? void 0 : _referencingElement$$3.toValue());
      const retrievalURI = reference.uri;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$4 = referencingElement.$ref) === null || _referencingElement$$4 === void 0 ? void 0 : _referencingElement$$4.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a referenced element
      if (isPrimitiveElement(referencedElement)) {
        referencedElement = PathItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing path item to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the referenced element
      const visitor = OpenApi3_0DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing path item from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // merge fields from referenced Path Item with referencing one
      const mergedResult = new PathItemElement(
      // @ts-ignore
      [...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
      // existing keywords from referencing PathItemElement overrides ones from referenced element
      referencingElement.forEach((value, keyElement, item) => {
        mergedResult.remove(keyElement.toValue());
        mergedResult.content.push(item);
      });
      mergedResult.remove('$ref');

      // annotate referenced element with info about original referencing element
      mergedResult.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$5 = referencingElement.$ref) === null || _referencingElement$$5 === void 0 ? void 0 : _referencingElement$$5.toValue()
      });
      // annotate referenced element with info about origin
      mergedResult.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return mergedResult;
    },
    async LinkElement(linkElement) {
      // ignore LinkElement without operationRef or operationId field
      if (!isStringElement(linkElement.operationRef) && !isStringElement(linkElement.operationId)) {
        return undefined;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isLinkElementExternal(linkElement)) {
        return undefined;
      }

      // operationRef and operationId fields are mutually exclusive
      if (isStringElement(linkElement.operationRef) && isStringElement(linkElement.operationId)) {
        throw new Error('LinkElement operationRef and operationId fields are mutually exclusive.');
      }

      // @ts-ignore
      let operationElement;
      if (isStringElement(linkElement.operationRef)) {
        var _linkElement$operatio, _linkElement$operatio2, _linkElement$operatio3;
        // possibly non-semantic referenced element
        const jsonPointer = uriToPointer((_linkElement$operatio = linkElement.operationRef) === null || _linkElement$operatio === void 0 ? void 0 : _linkElement$operatio.toValue());
        const reference = await this.toReference((_linkElement$operatio2 = linkElement.operationRef) === null || _linkElement$operatio2 === void 0 ? void 0 : _linkElement$operatio2.toValue());
        operationElement = evaluate(jsonPointer, reference.value.result);
        // applying semantics to a referenced element
        if (isPrimitiveElement(operationElement)) {
          operationElement = OperationElement.refract(operationElement);
        }
        // create shallow clone to be able to annotate with metadata
        operationElement = new OperationElement(
        // @ts-ignore
        [...operationElement.content], operationElement.meta.clone(), operationElement.attributes.clone());
        // annotate operation element with info about origin
        operationElement.setMetaProperty('ref-origin', reference.uri);
        (_linkElement$operatio3 = linkElement.operationRef) === null || _linkElement$operatio3 === void 0 ? void 0 : _linkElement$operatio3.meta.set('operation', operationElement);
      } else if (isStringElement(linkElement.operationId)) {
        var _linkElement$operatio4, _linkElement$operatio5;
        const operationId = (_linkElement$operatio4 = linkElement.operationId) === null || _linkElement$operatio4 === void 0 ? void 0 : _linkElement$operatio4.toValue();
        operationElement = find(e => isOperationElement(e) && e.operationId.equals(operationId), this.reference.value.result);
        // OperationElement not found by its operationId
        if (isUndefined(operationElement)) {
          throw new Error(`OperationElement(operationId=${operationId}) not found.`);
        }
        (_linkElement$operatio5 = linkElement.operationId) === null || _linkElement$operatio5 === void 0 ? void 0 : _linkElement$operatio5.meta.set('operation', operationElement);
      }
      return undefined;
    },
    async ExampleElement(exampleElement) {
      var _exampleElement$exter;
      // ignore ExampleElement without externalValue field
      if (!isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // ignore resolving ExampleElement externalValue
      if (!this.options.resolve.external && isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // value and externalValue fields are mutually exclusive
      if (exampleElement.hasKey('value') && isStringElement(exampleElement.externalValue)) {
        throw new Error('ExampleElement value and externalValue fields are mutually exclusive.');
      }
      const reference = await this.toReference((_exampleElement$exter = exampleElement.externalValue) === null || _exampleElement$exter === void 0 ? void 0 : _exampleElement$exter.toValue());

      // shallow clone of the referenced element
      const valueElement = new reference.value.result.constructor(reference.value.result.content, reference.value.result.meta.clone(), reference.value.result.attributes.clone());
      // annotate operation element with info about origin
      valueElement.setMetaProperty('ref-origin', reference.uri);

      // eslint-disable-next-line no-param-reassign
      exampleElement.value = valueElement;
      return undefined;
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      const [ancestorsLineage] = this.toAncestorLineage(ancestors);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }
      return undefined;
    }
  }
});
export default OpenApi3_0DereferenceVisitor;