import { Buffer } from '#buffer'; // eslint-disable-line import/order
import stampit from 'stampit';
import { ParseResultElement, StringElement } from '@swagger-api/apidom-core';
import { ParserError } from "../../../util/errors/index.js";
import Parser from "../Parser.js";
/**
 * Everything that is not recognized by other parsers will be considered by this parser
 * as a binary data and will be encoded to Base64 format.
 */
const BinaryParser = stampit(Parser, {
  props: {
    name: 'binary'
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      return hasSupportedFileExtension;
    },
    async parse(file) {
      let base64String;
      try {
        // @ts-ignore
        base64String = Buffer.from(file.data).toString('base64');
      } catch {
        base64String = Buffer.from(file.toString()).toString('base64');
      }
      try {
        const parseResultElement = new ParseResultElement();
        if (base64String.length !== 0) {
          const base64StringElement = new StringElement(base64String);
          base64StringElement.classes.push('result');
          parseResultElement.push(base64StringElement);
        }
        return parseResultElement;
      } catch (error) {
        throw new ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
export default BinaryParser;