import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { propEq, values, has, pipe } from 'ramda';
import { allP } from 'ramda-adjunct';
import { isPrimitiveElement, isStringElement, visit } from '@swagger-api/apidom-core';
import { evaluate, uriToPointer } from '@swagger-api/apidom-json-pointer';
import { getNodeType, isReferenceElement, isReferenceLikeElement, isPathItemElement, keyMap, ReferenceElement, PathItemElement, isReferenceElementExternal, isPathItemElementExternal, isLinkElementExternal } from '@swagger-api/apidom-ns-openapi-3-0';
import { MaximumDereferenceDepthError, MaximumResolverDepthError } from "../../../util/errors/index.js";
import * as url from "../../../util/url.js";
import parse from "../../../parse/index.js";
import Reference from "../../../Reference.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_0ResolveVisitor = stampit({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    crawledElements: null,
    crawlingMap: null,
    options: null
  },
  init({
    reference,
    namespace,
    indirections = [],
    options
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.crawledElements = [];
    this.crawlingMap = {};
    this.options = options;
  },
  methods: {
    toBaseURI(uri) {
      return url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = this.toBaseURI(uri);
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find(propEq('uri', baseURI));
      }
      const parseResult = await parse(url.unsanitize(baseURI), _objectSpread(_objectSpread({}, this.options), {}, {
        parse: _objectSpread(_objectSpread({}, this.options.parse), {}, {
          mediaType: 'text/plain'
        })
      }));

      // register new Reference with ReferenceSet
      const reference = Reference({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    ReferenceElement(referenceElement) {
      var _referenceElement$$re;
      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isReferenceElementExternal(referenceElement)) {
        return false;
      }
      const uri = (_referenceElement$$re = referenceElement.$ref) === null || _referenceElement$$re === void 0 ? void 0 : _referenceElement$$re.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!has(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(referenceElement);
      return undefined;
    },
    PathItemElement(pathItemElement) {
      var _pathItemElement$$ref;
      // ignore PathItemElement without $ref field
      if (!isStringElement(pathItemElement.$ref)) {
        return undefined;
      }

      // ignore resolving external Path Item Objects
      if (!this.options.resolve.external && isPathItemElementExternal(pathItemElement)) {
        return undefined;
      }
      const uri = (_pathItemElement$$ref = pathItemElement.$ref) === null || _pathItemElement$$ref === void 0 ? void 0 : _pathItemElement$$ref.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!has(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(pathItemElement);
      return undefined;
    },
    LinkElement(linkElement) {
      // ignore LinkElement without operationRef or operationId field
      if (!isStringElement(linkElement.operationRef) && !isStringElement(linkElement.operationId)) {
        return undefined;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isLinkElementExternal(linkElement)) {
        return undefined;
      }

      // operationRef and operationId are mutually exclusive
      if (isStringElement(linkElement.operationRef) && isStringElement(linkElement.operationId)) {
        throw new Error('LinkElement operationRef and operationId are mutually exclusive.');
      }
      if (isLinkElementExternal(linkElement)) {
        var _linkElement$operatio;
        const uri = (_linkElement$operatio = linkElement.operationRef) === null || _linkElement$operatio === void 0 ? void 0 : _linkElement$operatio.toValue();
        const baseURI = this.toBaseURI(uri);
        if (!has(baseURI, this.crawlingMap)) {
          this.crawlingMap[baseURI] = this.toReference(uri);
        }
      }
      return undefined;
    },
    ExampleElement(exampleElement) {
      var _exampleElement$exter;
      // ignore ExampleElement without externalValue field
      if (!isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // ignore resolving ExampleElement externalValue
      if (!this.options.resolve.external && isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // value and externalValue fields are mutually exclusive
      if (exampleElement.hasKey('value') && isStringElement(exampleElement.externalValue)) {
        throw new Error('ExampleElement value and externalValue fields are mutually exclusive.');
      }
      const uri = (_exampleElement$exter = exampleElement.externalValue) === null || _exampleElement$exter === void 0 ? void 0 : _exampleElement$exter.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!has(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      return undefined;
    },
    async crawlReferenceElement(referenceElement) {
      var _referenceElement$$re2;
      // @ts-ignore
      const reference = await this.toReference(referenceElement.$ref.toValue());
      this.indirections.push(referenceElement);
      const jsonPointer = uriToPointer((_referenceElement$$re2 = referenceElement.$ref) === null || _referenceElement$$re2 === void 0 ? void 0 : _referenceElement$$re2.toValue());

      // possibly non-semantic fragment
      let fragment = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(fragment)) {
        const referencedElementType = referenceElement.meta.get('referenced-element').toValue();
        if (isReferenceLikeElement(fragment)) {
          // handling indirect references
          fragment = ReferenceElement.refract(fragment);
          fragment.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          fragment = ElementClass.refract(fragment);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(fragment)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the fragment
      const visitor = OpenApi3_0ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(fragment, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawlPathItemElement(pathItemElement) {
      var _pathItemElement$$ref2, _pathItemElement$$ref3;
      // @ts-ignore
      const reference = await this.toReference((_pathItemElement$$ref2 = pathItemElement.$ref) === null || _pathItemElement$$ref2 === void 0 ? void 0 : _pathItemElement$$ref2.toValue());
      this.indirections.push(pathItemElement);
      const jsonPointer = uriToPointer((_pathItemElement$$ref3 = pathItemElement.$ref) === null || _pathItemElement$$ref3 === void 0 ? void 0 : _pathItemElement$$ref3.toValue());

      // possibly non-semantic fragment
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(referencedElement)) {
        referencedElement = PathItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the fragment
      const visitor = OpenApi3_0ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawl() {
      /**
       * Synchronize all parallel resolutions in this place.
       * After synchronization happened we can be sure that refSet
       * contains resolved Reference objects.
       */
      await pipe(values, allP)(this.crawlingMap);
      this.crawlingMap = null;

      /* eslint-disable no-await-in-loop */
      for (const element of this.crawledElements) {
        if (isReferenceElement(element)) {
          await this.crawlReferenceElement(element);
        } else if (isPathItemElement(element)) {
          await this.crawlPathItemElement(element);
        }
      }
      /* eslint-enabled */
    }
  }
});

export default OpenApi3_0ResolveVisitor;