import stampit from 'stampit';
import { createNamespace, visit } from '@swagger-api/apidom-core';
import openApi3_1Namespace, { getNodeType, isOpenApi3_1Element, keyMap, mediaTypes } from '@swagger-api/apidom-ns-openapi-3-1';
import ResolveStrategy from "../ResolveStrategy.js";
import ReferenceSet from "../../../ReferenceSet.js";
import Reference from "../../../Reference.js";
import OpenApi3_1ResolveVisitor from "./visitor.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_1ResolveStrategy = stampit(ResolveStrategy, {
  init() {
    this.name = 'openapi-3-1';
  },
  methods: {
    canResolve(file) {
      var _file$parseResult;
      // assert by media type
      if (file.mediaType !== 'text/plain') {
        return mediaTypes.includes(file.mediaType);
      }

      // assert by inspecting ApiDOM
      return isOpenApi3_1Element((_file$parseResult = file.parseResult) === null || _file$parseResult === void 0 ? void 0 : _file$parseResult.result);
    },
    async resolve(file, options) {
      const namespace = createNamespace(openApi3_1Namespace);
      const reference = Reference({
        uri: file.uri,
        value: file.parseResult
      });
      const visitor = OpenApi3_1ResolveVisitor({
        reference,
        namespace,
        options
      });
      const refSet = ReferenceSet();
      refSet.add(reference);
      await visitAsync(refSet.rootRef.value, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });
      await visitor.crawl();
      return refSet;
    }
  }
});
export default OpenApi3_1ResolveStrategy;