import { reduce } from 'ramda';
import { isPrimitiveElement } from '@swagger-api/apidom-core';
import { SchemaElement } from '@swagger-api/apidom-ns-openapi-3-1';
import * as url from "../../../util/url.js";
export const resolveSchema$refField = (retrieveURI, schemaElement) => {
  if (typeof schemaElement.$ref === 'undefined') {
    return undefined;
  }
  const hash = url.getHash(schemaElement.$ref.toValue());
  const inherited$id = schemaElement.meta.get('inherited$id').toValue();
  const $refBaseURI = reduce((acc, uri) => {
    return url.resolve(acc, url.sanitize(url.stripHash(uri)));
  }, retrieveURI, [...inherited$id, schemaElement.$ref.toValue()]);
  return `${$refBaseURI}${hash === '#' ? '' : hash}`;
};
export const resolveSchema$idField = (retrieveURI, schemaElement) => {
  if (typeof schemaElement.$id === 'undefined') {
    return undefined;
  }
  const inherited$id = schemaElement.meta.get('inherited$id').toValue();
  return reduce((acc, $id) => {
    return url.resolve(acc, url.sanitize(url.stripHash($id)));
  }, retrieveURI, [...inherited$id, schemaElement.$id.toValue()]);
};

/**
 * Cached version of SchemaElement.refract.
 */
export const refractToSchemaElement = element => {
  if (refractToSchemaElement.cache.has(element)) {
    return refractToSchemaElement.cache.get(element);
  }
  const refracted = SchemaElement.refract(element);
  refractToSchemaElement.cache.set(element, refracted);
  return refracted;
};
refractToSchemaElement.cache = new WeakMap();
export const maybeRefractToSchemaElement = element => {
  /**
   * Conditional version of refractToSchemaElement, that acts as an identity
   * function for all non-primitive Element instances.
   */
  if (isPrimitiveElement(element)) {
    return refractToSchemaElement(element);
  }
  return element;
};