"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = _interopRequireWildcard(require("@swagger-api/apidom-ns-openapi-3-1"));
var _ResolveStrategy = _interopRequireDefault(require("../ResolveStrategy.cjs"));
var _ReferenceSet = _interopRequireDefault(require("../../../ReferenceSet.cjs"));
var _Reference = _interopRequireDefault(require("../../../Reference.cjs"));
var _visitor = _interopRequireDefault(require("./visitor.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// @ts-ignore
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_1ResolveStrategy = (0, _stampit.default)(_ResolveStrategy.default, {
  init() {
    this.name = 'openapi-3-1';
  },
  methods: {
    canResolve(file) {
      var _file$parseResult;
      // assert by media type
      if (file.mediaType !== 'text/plain') {
        return _apidomNsOpenapi.mediaTypes.includes(file.mediaType);
      }

      // assert by inspecting ApiDOM
      return (0, _apidomNsOpenapi.isOpenApi3_1Element)((_file$parseResult = file.parseResult) === null || _file$parseResult === void 0 ? void 0 : _file$parseResult.result);
    },
    async resolve(file, options) {
      const namespace = (0, _apidomCore.createNamespace)(_apidomNsOpenapi.default);
      const reference = (0, _Reference.default)({
        uri: file.uri,
        value: file.parseResult
      });
      const visitor = (0, _visitor.default)({
        reference,
        namespace,
        options
      });
      const refSet = (0, _ReferenceSet.default)();
      refSet.add(reference);
      await visitAsync(refSet.rootRef.value, visitor, {
        keyMap: _apidomNsOpenapi.keyMap,
        nodeTypeGetter: _apidomNsOpenapi.getNodeType
      });
      await visitor.crawl();
      return refSet;
    }
  }
});
var _default = OpenApi3_1ResolveStrategy;
exports.default = _default;