"use strict";

exports.__esModule = true;
exports.resolveSchema$refField = exports.resolveSchema$idField = exports.refractToSchemaElement = exports.maybeRefractToSchemaElement = void 0;
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var url = _interopRequireWildcard(require("../../../util/url.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const resolveSchema$refField = (retrieveURI, schemaElement) => {
  if (typeof schemaElement.$ref === 'undefined') {
    return undefined;
  }
  const hash = url.getHash(schemaElement.$ref.toValue());
  const inherited$id = schemaElement.meta.get('inherited$id').toValue();
  const $refBaseURI = (0, _ramda.reduce)((acc, uri) => {
    return url.resolve(acc, url.sanitize(url.stripHash(uri)));
  }, retrieveURI, [...inherited$id, schemaElement.$ref.toValue()]);
  return `${$refBaseURI}${hash === '#' ? '' : hash}`;
};
exports.resolveSchema$refField = resolveSchema$refField;
const resolveSchema$idField = (retrieveURI, schemaElement) => {
  if (typeof schemaElement.$id === 'undefined') {
    return undefined;
  }
  const inherited$id = schemaElement.meta.get('inherited$id').toValue();
  return (0, _ramda.reduce)((acc, $id) => {
    return url.resolve(acc, url.sanitize(url.stripHash($id)));
  }, retrieveURI, [...inherited$id, schemaElement.$id.toValue()]);
};

/**
 * Cached version of SchemaElement.refract.
 */
exports.resolveSchema$idField = resolveSchema$idField;
const refractToSchemaElement = element => {
  if (refractToSchemaElement.cache.has(element)) {
    return refractToSchemaElement.cache.get(element);
  }
  const refracted = _apidomNsOpenapi.SchemaElement.refract(element);
  refractToSchemaElement.cache.set(element, refracted);
  return refracted;
};
exports.refractToSchemaElement = refractToSchemaElement;
refractToSchemaElement.cache = new WeakMap();
const maybeRefractToSchemaElement = element => {
  /**
   * Conditional version of refractToSchemaElement, that acts as an identity
   * function for all non-primitive Element instances.
   */
  if ((0, _apidomCore.isPrimitiveElement)(element)) {
    return refractToSchemaElement(element);
  }
  return element;
};
exports.maybeRefractToSchemaElement = maybeRefractToSchemaElement;