"use strict";

exports.__esModule = true;
exports.default = void 0;
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
class CausedError extends Error {
  constructor(message, options) {
    super(message);
    this.name = this.constructor.name;
    this.message = message;
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }
    if ((0, _ramdaAdjunct.isPlainObject)(options) && (0, _ramda.hasIn)('cause', options) && !(0, _ramda.hasIn)('cause', this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if ((0, _ramda.hasIn)('stack', cause)) {
        this.stack = `${this.stack}\nCAUSE: ${cause === null || cause === void 0 ? void 0 : cause.stack}`;
      }
    }
  }
}
var _default = CausedError;
exports.default = _default;