import stampit from 'stampit';
import { NotImplementedError } from "../../util/errors/index.js";
const Parser = stampit({
  props: {
    name: '',
    /**
     * Whether to allow "empty" files. This includes zero-byte files.
     */
    allowEmpty: true,
    /**
     * Whether to generate source map during parsing.
     */
    sourceMap: false,
    /**
     * List of supported file extensions.
     */
    fileExtensions: [],
    /**
     * List of supported media types.
     */
    mediaTypes: []
  },
  init({
    allowEmpty = this.allowEmpty,
    sourceMap = this.sourceMap,
    fileExtensions = this.fileExtensions,
    mediaTypes = this.mediaTypes
  } = {}) {
    this.allowEmpty = allowEmpty;
    this.sourceMap = sourceMap;
    this.fileExtensions = fileExtensions;
    this.mediaTypes = mediaTypes;
  },
  methods: {
    async canParse() {
      throw new NotImplementedError();
    },
    async parse() {
      throw new NotImplementedError();
    }
  }
});
export default Parser;