import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { omit, pathOr } from 'ramda';
import { ensureArray } from 'ramda-adjunct';
import axios from 'axios';
import ResolverError from "../../../util/errors/ResolverError.js";
import HttpResolver from "../HttpResolver.js";
const HttpResolverAxios = stampit(HttpResolver).init(function HttpResolverAxios() {
  /**
   * Private Api.
   */
  let axiosInstance;
  let oldAxiosConfig;

  /**
   * Public Api.
   */

  this.name = 'http-axios';
  this.axiosConfig = {};
  this.getHttpClient = function getHttpClient() {
    if (typeof axiosInstance === 'undefined' || oldAxiosConfig !== this.axiosConfig) {
      const config = omit(['interceptors'], this.axiosConfig);
      const interceptors = pathOr({
        request: [],
        response: []
      }, ['axiosConfig', 'interceptors'], this);
      axiosInstance = axios.create(_objectSpread({
        timeout: this.timeout,
        maxRedirects: this.redirects,
        withCredentials: this.withCredentials,
        responseType: 'arraybuffer'
      }, config));

      // settings up request interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.request)) {
        interceptors.request.forEach(requestInterceptor => {
          axiosInstance.interceptors.request.use(...ensureArray(requestInterceptor));
        });
      }

      // settings up response interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.response)) {
        interceptors.response.forEach(responseInterceptor => {
          axiosInstance.interceptors.response.use(...ensureArray(responseInterceptor));
        });
      }
      oldAxiosConfig = this.axiosConfig;
    }
    return axiosInstance;
  };
  this.read = async function read(file) {
    const client = this.getHttpClient();
    try {
      const response = await client.get(file.uri);
      return response.data;
    } catch (error) {
      throw new ResolverError(`Error downloading "${file.uri}"`, {
        cause: error
      });
    }
  };
});
export default HttpResolverAxios;