import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { propEq, values, has, pipe } from 'ramda';
import { allP } from 'ramda-adjunct';
import { isPrimitiveElement, isStringElement, visit } from '@swagger-api/apidom-core';
import { evaluate, uriToPointer } from '@swagger-api/apidom-json-pointer';
import { getNodeType, isReferenceElement, isChannelItemElement, isReferenceLikeElement, keyMap, ReferenceElement, ChannelItemElement, isReferenceElementExternal, isChannelItemElementExternal } from '@swagger-api/apidom-ns-asyncapi-2';
import { MaximumDereferenceDepthError, MaximumResolverDepthError } from "../../../util/errors/index.js";
import * as url from "../../../util/url.js";
import parse from "../../../parse/index.js";
import Reference from "../../../Reference.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];
const AsyncApi2ResolveVisitor = stampit({
  props: {
    indirections: [],
    namespace: null,
    reference: null,
    crawledElements: null,
    crawlingMap: null,
    options: null
  },
  init({
    reference,
    namespace,
    indirections = [],
    options
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.crawledElements = [];
    this.crawlingMap = {};
    this.options = options;
  },
  methods: {
    toBaseURI(uri) {
      return url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = this.toBaseURI(uri);
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find(propEq(baseURI, 'uri'));
      }
      const parseResult = await parse(url.unsanitize(baseURI), _objectSpread(_objectSpread({}, this.options), {}, {
        parse: _objectSpread(_objectSpread({}, this.options.parse), {}, {
          mediaType: 'text/plain'
        })
      }));

      // register new Reference with ReferenceSet
      const reference = Reference({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    ReferenceElement(referenceElement) {
      var _referenceElement$$re;
      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isReferenceElementExternal(referenceElement)) {
        return false;
      }
      const uri = (_referenceElement$$re = referenceElement.$ref) === null || _referenceElement$$re === void 0 ? void 0 : _referenceElement$$re.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!has(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(referenceElement);
      return undefined;
    },
    ChannelItemElement(channelItemElement) {
      var _channelItemElement$$;
      // ignore PathItemElement without $ref field
      if (!isStringElement(channelItemElement.$ref)) {
        return undefined;
      }

      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isChannelItemElementExternal(channelItemElement)) {
        return undefined;
      }
      const uri = (_channelItemElement$$ = channelItemElement.$ref) === null || _channelItemElement$$ === void 0 ? void 0 : _channelItemElement$$.toValue();
      const baseURI = this.toBaseURI(uri);
      if (!has(baseURI, this.crawlingMap)) {
        this.crawlingMap[baseURI] = this.toReference(uri);
      }
      this.crawledElements.push(channelItemElement);
      return undefined;
    },
    async crawlReferenceElement(referenceElement) {
      var _referenceElement$$re2, _referenceElement$$re3;
      // @ts-ignore
      const reference = await this.toReference((_referenceElement$$re2 = referenceElement.$ref) === null || _referenceElement$$re2 === void 0 ? void 0 : _referenceElement$$re2.toValue());
      this.indirections.push(referenceElement);
      const jsonPointer = uriToPointer((_referenceElement$$re3 = referenceElement.$ref) === null || _referenceElement$$re3 === void 0 ? void 0 : _referenceElement$$re3.toValue());

      // possibly non-semantic fragment
      let fragment = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(fragment)) {
        const referencedElementType = referenceElement.meta.get('referenced-element').toValue();
        if (isReferenceLikeElement(fragment)) {
          // handling indirect references
          fragment = ReferenceElement.refract(fragment);
          fragment.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          fragment = ElementClass.refract(fragment);
        }
      }

      // detect direct or circular reference
      if (this.indirections.includes(fragment)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the fragment
      const visitor = AsyncApi2ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(fragment, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawlChannelItemElement(channelItemElement) {
      var _channelItemElement$$2, _channelItemElement$$3;
      // @ts-ignore
      const reference = await this.toReference((_channelItemElement$$2 = channelItemElement.$ref) === null || _channelItemElement$$2 === void 0 ? void 0 : _channelItemElement$$2.toValue());
      this.indirections.push(channelItemElement);
      const jsonPointer = uriToPointer((_channelItemElement$$3 = channelItemElement.$ref) === null || _channelItemElement$$3 === void 0 ? void 0 : _channelItemElement$$3.toValue());

      // possibly non-semantic referenced element
      let referencedElement = evaluate(jsonPointer, reference.value.result);

      // applying semantics to a referenced element
      if (isPrimitiveElement(referencedElement)) {
        referencedElement = ChannelItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Channel Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // dive deep into the referenced element
      const visitor = AsyncApi2ResolveVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options
      });
      await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });
      await visitor.crawl();
      this.indirections.pop();
    },
    async crawl() {
      /**
       * Synchronize all parallel resolutions in this place.
       * After synchronization happened we can be sure that refSet
       * contains resolved Reference objects.
       */
      await pipe(values, allP)(this.crawlingMap);
      this.crawlingMap = null;

      /* eslint-disable no-await-in-loop */
      for (const element of this.crawledElements) {
        if (isReferenceElement(element)) {
          await this.crawlReferenceElement(element);
        } else if (isChannelItemElement(element)) {
          await this.crawlChannelItemElement(element);
        }
      }
      /* eslint-enabled */
    }
  }
});

export default AsyncApi2ResolveVisitor;