/// <reference types="node" />
/// <reference types="@swagger-api/apidom-core/types/minim" />
import { ParseResultElement, Element } from '@swagger-api/apidom-core';
import File from './util/File';
import * as url from './util/url';
import { ReferenceSet as IReferenceSet } from './types';
export { url, File };
export { default as Parser } from './parse/parsers/Parser';
export { default as Resolver } from './resolve/resolvers/Resolver';
export { default as HttpResolver } from './resolve/resolvers/HttpResolver';
export { default as ResolveStrategy } from './resolve/strategies/ResolveStrategy';
export { default as DereferenceStrategy } from './dereference/strategies/DereferenceStrategy';
export { default as options } from './options';
export { merge as mergeOptions } from './options/util';
export { default as Reference } from './Reference';
export { default as ReferenceSet } from './ReferenceSet';
export { DereferenceError, InvalidSelectorError, MaximumDereferenceDepthError, MaximumResolverDepthError, NotImplementedError, ParserError, PluginError, ResolverError, UnmatchedDereferenceStrategyError, UnmatchedResolveStrategyError, UnmatchedResolverError, } from './util/errors';
export declare const readFile: (uri: string, options?: {}) => Promise<Buffer>;
export declare const parse: (uri: string, options?: {}) => Promise<ParseResultElement>;
export declare const resolve: (uri: string, options?: {}) => Promise<IReferenceSet>;
export declare const resolveApiDOM: <T extends Element>(element: T, options?: {}) => Promise<IReferenceSet>;
export declare const dereference: (uri: string, options?: {}) => Promise<ParseResultElement>;
export declare const dereferenceApiDOM: <T extends Element>(element: T, options?: {}) => Promise<T>;
