/// <reference types="@swagger-api/apidom-core/types/minim" />
import { Element } from '@swagger-api/apidom-core';
import { ReferenceOptions as IReferenceOptions, ReferenceSet as IReferenceSet } from '../types';
/**
 * Resolves ApiDOM with all its external references.
 */
export declare const resolveApiDOM: <T extends Element>(element: T, options: IReferenceOptions) => Promise<IReferenceSet>;
/**
 * Resolves a file with all its external references.
 */
declare const resolve: (uri: string, options: IReferenceOptions) => Promise<IReferenceSet>;
export default resolve;
