"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.url = exports.resolveApiDOM = exports.resolve = exports.readFile = exports.parse = exports.options = exports.mergeOptions = exports.dereferenceApiDOM = exports.dereference = exports.UnmatchedResolverError = exports.UnmatchedResolveStrategyError = exports.UnmatchedDereferenceStrategyError = exports.ResolverError = exports.Resolver = exports.ResolveStrategy = exports.ReferenceSet = exports.Reference = exports.PluginError = exports.ParserError = exports.Parser = exports.NotImplementedError = exports.MaximumResolverDepthError = exports.MaximumDereferenceDepthError = exports.InvalidSelectorError = exports.HttpResolver = exports.DereferenceStrategy = exports.DereferenceError = void 0;
var _File = _interopRequireDefault(require("./util/File.cjs"));
exports.File = _File.default;
var url = _interopRequireWildcard(require("./util/url.cjs"));
exports.url = url;
var _index = _interopRequireDefault(require("./options/index.cjs"));
exports.options = _index.default;
var _util = require("./options/util.cjs");
exports.mergeOptions = _util.merge;
var _index2 = _interopRequireDefault(require("./parse/index.cjs"));
var _index3 = _interopRequireWildcard(require("./resolve/index.cjs"));
var _util2 = require("./resolve/util.cjs");
var _index4 = _interopRequireWildcard(require("./dereference/index.cjs"));
var _Parser = _interopRequireDefault(require("./parse/parsers/Parser.cjs"));
exports.Parser = _Parser.default;
var _Resolver = _interopRequireDefault(require("./resolve/resolvers/Resolver.cjs"));
exports.Resolver = _Resolver.default;
var _HttpResolver = _interopRequireDefault(require("./resolve/resolvers/HttpResolver.cjs"));
exports.HttpResolver = _HttpResolver.default;
var _ResolveStrategy = _interopRequireDefault(require("./resolve/strategies/ResolveStrategy.cjs"));
exports.ResolveStrategy = _ResolveStrategy.default;
var _DereferenceStrategy = _interopRequireDefault(require("./dereference/strategies/DereferenceStrategy.cjs"));
exports.DereferenceStrategy = _DereferenceStrategy.default;
var _Reference = _interopRequireDefault(require("./Reference.cjs"));
exports.Reference = _Reference.default;
var _ReferenceSet = _interopRequireDefault(require("./ReferenceSet.cjs"));
exports.ReferenceSet = _ReferenceSet.default;
var _index5 = require("./util/errors/index.cjs");
exports.DereferenceError = _index5.DereferenceError;
exports.InvalidSelectorError = _index5.InvalidSelectorError;
exports.MaximumDereferenceDepthError = _index5.MaximumDereferenceDepthError;
exports.MaximumResolverDepthError = _index5.MaximumResolverDepthError;
exports.NotImplementedError = _index5.NotImplementedError;
exports.ParserError = _index5.ParserError;
exports.PluginError = _index5.PluginError;
exports.ResolverError = _index5.ResolverError;
exports.UnmatchedDereferenceStrategyError = _index5.UnmatchedDereferenceStrategyError;
exports.UnmatchedResolveStrategyError = _index5.UnmatchedResolveStrategyError;
exports.UnmatchedResolverError = _index5.UnmatchedResolverError;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const readFile = async (uri, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  const file = (0, _File.default)({
    uri: url.sanitize(uri)
  });
  return (0, _util2.readFile)(file, mergedOptions);
};
exports.readFile = readFile;
const parse = async (uri, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  return (0, _index2.default)(uri, mergedOptions);
};
exports.parse = parse;
const resolve = async (uri, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  return (0, _index3.default)(uri, mergedOptions);
};
exports.resolve = resolve;
const resolveApiDOM = async (element, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  return (0, _index3.resolveApiDOM)(element, mergedOptions);
};
exports.resolveApiDOM = resolveApiDOM;
const dereference = async (uri, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  return (0, _index4.default)(uri, mergedOptions);
};
exports.dereference = dereference;
const dereferenceApiDOM = async (element, options = {}) => {
  const mergedOptions = (0, _util.merge)(_index.default, options);
  return (0, _index4.dereferenceApiDOM)(element, mergedOptions);
};
exports.dereferenceApiDOM = dereferenceApiDOM;