"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _index = require("../../util/errors/index.cjs");
const Parser = (0, _stampit.default)({
  props: {
    name: '',
    /**
     * Whether to allow "empty" files. This includes zero-byte files.
     */
    allowEmpty: true,
    /**
     * Whether to generate source map during parsing.
     */
    sourceMap: false,
    /**
     * List of supported file extensions.
     */
    fileExtensions: [],
    /**
     * List of supported media types.
     */
    mediaTypes: []
  },
  init({
    allowEmpty = this.allowEmpty,
    sourceMap = this.sourceMap,
    fileExtensions = this.fileExtensions,
    mediaTypes = this.mediaTypes
  } = {}) {
    this.allowEmpty = allowEmpty;
    this.sourceMap = sourceMap;
    this.fileExtensions = fileExtensions;
    this.mediaTypes = mediaTypes;
  },
  methods: {
    async canParse() {
      throw new _index.NotImplementedError();
    },
    async parse() {
      throw new _index.NotImplementedError();
    }
  }
});
var _default = Parser;
exports.default = _default;