"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _index = require("../../../util/errors/index.cjs");
var _Parser = _interopRequireDefault(require("../Parser.cjs"));
/**
 * Everything that is not recognized by other parsers will be considered by this parser
 * as a binary data and will be encoded to Base64 format.
 */

const BinaryParser = (0, _stampit.default)(_Parser.default, {
  props: {
    name: 'binary'
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      return hasSupportedFileExtension;
    },
    async parse(file) {
      try {
        /**
         * More information about binary strings and btoa function in following link:
         *   https://developer.mozilla.org/en-US/docs/Web/API/btoa
         *
         * @example
         * ArrayBuffer to base64 conversion:
         *
         * const binaryString = String.fromCharCode.apply(null, file.data);
         * base64String = btoa(binaryString);
         */
        const binaryString = unescape(encodeURIComponent(file.toString()));
        const base64String = btoa(binaryString);
        const parseResultElement = new _apidomCore.ParseResultElement();
        if (base64String.length !== 0) {
          const base64StringElement = new _apidomCore.StringElement(base64String);
          base64StringElement.classes.push('result');
          parseResultElement.push(base64StringElement);
        }
        return parseResultElement;
      } catch (error) {
        throw new _index.ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = BinaryParser;
exports.default = _default;