"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _apidomParserAdapterOpenapiYaml = require("@swagger-api/apidom-parser-adapter-openapi-yaml-3-0");
var _index = require("../../../util/errors/index.cjs");
var _Parser = _interopRequireDefault(require("../Parser.cjs"));
// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApiYaml3_0Parser = (0, _stampit.default)(_Parser.default, {
  props: {
    name: 'openapi-yaml-3-0',
    fileExtensions: ['.yaml', '.yml'],
    mediaTypes: _apidomParserAdapterOpenapiYaml.mediaTypes
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        return (0, _apidomParserAdapterOpenapiYaml.detect)(file.toString());
      }
      return false;
    },
    async parse(file) {
      const source = file.toString();
      try {
        const parserOpts = (0, _ramda.pick)(['sourceMap', 'refractorOpts'], this);
        return await (0, _apidomParserAdapterOpenapiYaml.parse)(source, parserOpts);
      } catch (error) {
        throw new _index.ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = OpenApiYaml3_0Parser;
exports.default = _default;