"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.resolveApiDOM = exports.default = void 0;
var _ramda = require("ramda");
var _apidomCore = require("@swagger-api/apidom-core");
var _util = require("../options/util.cjs");
var _index = _interopRequireDefault(require("../parse/index.cjs"));
var plugins = _interopRequireWildcard(require("../util/plugins.cjs"));
var _File = _interopRequireDefault(require("../util/File.cjs"));
var _index2 = require("../util/errors/index.cjs");
var url = _interopRequireWildcard(require("../util/url.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Resolves ApiDOM with all its external references.
 */
const resolveApiDOM = async (element, options) => {
  // @ts-ignore
  let parseResult = element;

  // wrap element into parse result
  if (!(0, _apidomCore.isParseResultElement)(element)) {
    // shallow clone of the element
    // @ts-ignore
    const elementClone = new element.constructor(element.content, element.meta.clone(), element.attributes);
    elementClone.classes.push('result');
    parseResult = new _apidomCore.ParseResultElement([elementClone]);
  }
  const sanitizedURI = url.sanitize(url.stripHash(options.resolve.baseURI));
  const file = (0, _File.default)({
    uri: sanitizedURI,
    parseResult,
    mediaType: options.parse.mediaType
  });
  const resolveStrategies = await plugins.filter('canResolve', file, options.resolve.strategies);

  // we couldn't find any resolver for this File
  if ((0, _ramda.isEmpty)(resolveStrategies)) {
    throw new _index2.UnmatchedResolveStrategyError(file.uri);
  }
  try {
    const {
      result
    } = await plugins.run('resolve', [file, options], resolveStrategies);
    return result;
  } catch (error) {
    throw new _index2.ResolverError(`Error while resolving file "${file.uri}"`, {
      cause: error
    });
  }
};

/**
 * Resolves a file with all its external references.
 */
exports.resolveApiDOM = resolveApiDOM;
const resolve = async (uri, options) => {
  const parseResult = await (0, _index.default)(uri, options);
  const mergedOptions = (0, _util.merge)(options, {
    resolve: {
      baseURI: uri
    }
  });
  return resolveApiDOM(parseResult, mergedOptions);
};
var _default = resolve;
exports.default = _default;