"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _axios = _interopRequireDefault(require("axios"));
var _ResolverError = _interopRequireDefault(require("../../../util/errors/ResolverError.cjs"));
var _HttpResolver = _interopRequireDefault(require("../HttpResolver.cjs"));
const HttpResolverAxios = (0, _stampit.default)(_HttpResolver.default).init(function HttpResolverAxios() {
  /**
   * Private Api.
   */
  let axiosInstance;
  let oldAxiosConfig;

  /**
   * Public Api.
   */

  this.name = 'http-axios';
  this.axiosConfig = {};
  this.getHttpClient = function getHttpClient() {
    if (typeof axiosInstance === 'undefined' || oldAxiosConfig !== this.axiosConfig) {
      const config = (0, _ramda.omit)(['interceptors'], this.axiosConfig);
      const interceptors = (0, _ramda.pathOr)({
        request: [],
        response: []
      }, ['axiosConfig', 'interceptors'], this);
      axiosInstance = _axios.default.create({
        timeout: this.timeout,
        maxRedirects: this.redirects,
        withCredentials: this.withCredentials,
        responseType: 'arraybuffer',
        ...config
      });

      // settings up request interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.request)) {
        interceptors.request.forEach(requestInterceptor => {
          axiosInstance.interceptors.request.use(...(0, _ramdaAdjunct.ensureArray)(requestInterceptor));
        });
      }

      // settings up response interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.response)) {
        interceptors.response.forEach(responseInterceptor => {
          axiosInstance.interceptors.response.use(...(0, _ramdaAdjunct.ensureArray)(responseInterceptor));
        });
      }
      oldAxiosConfig = this.axiosConfig;
    }
    return axiosInstance;
  };
  this.read = async function read(file) {
    const client = this.getHttpClient();
    try {
      const response = await client.get(file.uri);
      return response.data;
    } catch (error) {
      throw new _ResolverError.default(`Error downloading "${file.uri}"`, {
        cause: error
      });
    }
  };
});
var _default = HttpResolverAxios;
exports.default = _default;