import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import stampit from 'stampit';
import { hasIn, pathSatisfies, propEq, none } from 'ramda';
import { isUndefined, isNotUndefined } from 'ramda-adjunct';
import { isPrimitiveElement, isStringElement, visit, find, isElement } from '@swagger-api/apidom-core';
import { evaluate as jsonPointerEvaluate, uriToPointer } from '@swagger-api/apidom-json-pointer';
import { getNodeType, isReferenceLikeElement, keyMap, ReferenceElement, PathItemElement, OperationElement, SchemaElement, isReferenceElementExternal, isPathItemElementExternal, isLinkElementExternal, isOperationElement, isBooleanJsonSchemaElement } from '@swagger-api/apidom-ns-openapi-3-1';
import { isAnchor, uriToAnchor, evaluate as $anchorEvaluate } from "./selectors/$anchor/index.js";
import { evaluate as uriEvaluate } from "./selectors/uri/index.js";
import { MaximumDereferenceDepthError, MaximumResolverDepthError } from "../../../util/errors/index.js";
import * as url from "../../../util/url.js";
import parse from "../../../parse/index.js";
import Reference from "../../../Reference.js";
import File from "../../../util/File.js";
import { resolveSchema$refField, maybeRefractToSchemaElement } from "../../../resolve/strategies/openapi-3-1/util.js";
import EvaluationJsonSchemaUriError from "./selectors/uri/errors/EvaluationJsonSchemaUriError.js"; // @ts-ignore
const visitAsync = visit[Symbol.for('nodejs.util.promisify.custom')];

// eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApi3_1DereferenceVisitor = stampit({
  props: {
    indirections: null,
    namespace: null,
    reference: null,
    options: null,
    ancestors: null
  },
  init({
    indirections = [],
    reference,
    namespace,
    options,
    ancestors = []
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.options = options;
    this.ancestors = [...ancestors];
  },
  methods: {
    toBaseURI(uri) {
      return url.resolve(this.reference.uri, url.sanitize(url.stripHash(uri)));
    },
    toAncestorLineage(ancestors) {
      /**
       * Compute full ancestors lineage.
       * Ancestors are flatten to unwrap all Element instances.
       */
      const directAncestors = new WeakSet(ancestors.filter(isElement));
      const ancestorsLineage = [...this.ancestors, directAncestors];
      return [ancestorsLineage, directAncestors];
    },
    async toReference(uri) {
      // detect maximum depth of resolution
      if (this.reference.depth >= this.options.resolve.maxDepth) {
        throw new MaximumResolverDepthError(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
      }
      const baseURI = this.toBaseURI(uri);
      const {
        refSet
      } = this.reference;

      // we've already processed this Reference in past
      if (refSet.has(baseURI)) {
        return refSet.find(propEq(baseURI, 'uri'));
      }
      const parseResult = await parse(url.unsanitize(baseURI), _objectSpread(_objectSpread({}, this.options), {}, {
        parse: _objectSpread(_objectSpread({}, this.options.parse), {}, {
          mediaType: 'text/plain'
        })
      }));

      // register new Reference with ReferenceSet
      const reference = Reference({
        uri: baseURI,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(reference);
      return reference;
    },
    async ReferenceElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$, _referencingElement$$2, _referencingElement$$3, _referencingElement$d, _referencingElement$s;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isReferenceElementExternal(referencingElement)) {
        return false;
      }
      const reference = await this.toReference((_referencingElement$$ = referencingElement.$ref) === null || _referencingElement$$ === void 0 ? void 0 : _referencingElement$$.toValue());
      const {
        uri: retrievalURI
      } = reference;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$2 = referencingElement.$ref) === null || _referencingElement$$2 === void 0 ? void 0 : _referencingElement$$2.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = jsonPointerEvaluate(jsonPointer, reference.value.result);

      // applying semantics to a fragment
      if (isPrimitiveElement(referencedElement)) {
        const referencedElementType = referencingElement.meta.get('referenced-element').toValue();
        if (isReferenceLikeElement(referencedElement)) {
          // handling indirect references
          referencedElement = ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
        }
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the fragment
      const visitor = OpenApi3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // annotate fragment with info about original Reference element
      referencedElement = referencedElement.clone();
      referencedElement.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$3 = referencingElement.$ref) === null || _referencingElement$$3 === void 0 ? void 0 : _referencingElement$$3.toValue(),
        // @ts-ignore
        description: (_referencingElement$d = referencingElement.description) === null || _referencingElement$d === void 0 ? void 0 : _referencingElement$d.toValue(),
        // @ts-ignore
        summary: (_referencingElement$s = referencingElement.summary) === null || _referencingElement$s === void 0 ? void 0 : _referencingElement$s.toValue()
      });
      // annotate fragment with info about origin
      referencedElement.setMetaProperty('ref-origin', reference.uri);

      // override description and summary (outer has higher priority then inner)
      const hasDescription = pathSatisfies(isNotUndefined, ['description'], referencingElement);
      const hasSummary = pathSatisfies(isNotUndefined, ['summary'], referencingElement);
      if (hasDescription && hasIn('description', referencedElement)) {
        // @ts-ignore
        referencedElement.description = referencingElement.description;
      }
      if (hasSummary && hasIn('summary', referencedElement)) {
        // @ts-ignore
        referencedElement.summary = referencingElement.summary;
      }
      this.indirections.pop();

      // transclude the element for a fragment
      return referencedElement;
    },
    async PathItemElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$4, _referencingElement$$5, _referencingElement$$6;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

      // ignore PathItemElement without $ref field
      if (!isStringElement(referencingElement.$ref)) {
        return undefined;
      }

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isPathItemElementExternal(referencingElement)) {
        return undefined;
      }
      const reference = await this.toReference((_referencingElement$$4 = referencingElement.$ref) === null || _referencingElement$$4 === void 0 ? void 0 : _referencingElement$$4.toValue());
      const {
        uri: retrievalURI
      } = reference;
      const $refBaseURI = url.resolve(retrievalURI, (_referencingElement$$5 = referencingElement.$ref) === null || _referencingElement$$5 === void 0 ? void 0 : _referencingElement$$5.toValue());
      this.indirections.push(referencingElement);
      const jsonPointer = uriToPointer($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = jsonPointerEvaluate(jsonPointer, reference.value.result);

      // applying semantics to a referenced element
      if (isPrimitiveElement(referencedElement)) {
        referencedElement = PathItemElement.refract(referencedElement);
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing path item to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the referenced element
      const visitor = OpenApi3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing path item from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // merge fields from referenced Path Item with referencing one
      const mergedResult = new PathItemElement(
      // @ts-ignore
      [...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
      // existing keywords from referencing PathItemElement overrides ones from referenced element
      referencingElement.forEach((value, keyElement, item) => {
        mergedResult.remove(keyElement.toValue());
        mergedResult.content.push(item);
      });
      mergedResult.remove('$ref');

      // annotate referenced element with info about original referencing element
      mergedResult.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$6 = referencingElement.$ref) === null || _referencingElement$$6 === void 0 ? void 0 : _referencingElement$$6.toValue()
      });
      // annotate referenced element with info about origin
      mergedResult.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return mergedResult;
    },
    async LinkElement(linkElement) {
      // ignore LinkElement without operationRef or operationId field
      if (!isStringElement(linkElement.operationRef) && !isStringElement(linkElement.operationId)) {
        return undefined;
      }

      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isLinkElementExternal(linkElement)) {
        return undefined;
      }

      // operationRef and operationId fields are mutually exclusive
      if (isStringElement(linkElement.operationRef) && isStringElement(linkElement.operationId)) {
        throw new Error('LinkElement operationRef and operationId fields are mutually exclusive.');
      }

      // @ts-ignore
      let operationElement;
      if (isStringElement(linkElement.operationRef)) {
        var _linkElement$operatio, _linkElement$operatio2, _linkElement$operatio3;
        // possibly non-semantic referenced element
        const jsonPointer = uriToPointer((_linkElement$operatio = linkElement.operationRef) === null || _linkElement$operatio === void 0 ? void 0 : _linkElement$operatio.toValue());
        const reference = await this.toReference((_linkElement$operatio2 = linkElement.operationRef) === null || _linkElement$operatio2 === void 0 ? void 0 : _linkElement$operatio2.toValue());
        operationElement = jsonPointerEvaluate(jsonPointer, reference.value.result);
        // applying semantics to a referenced element
        if (isPrimitiveElement(operationElement)) {
          operationElement = OperationElement.refract(operationElement);
        }
        // create shallow clone to be able to annotate with metadata
        operationElement = new OperationElement(
        // @ts-ignore
        [...operationElement.content], operationElement.meta.clone(), operationElement.attributes.clone());
        // annotate operation element with info about origin
        operationElement.setMetaProperty('ref-origin', reference.uri);
        (_linkElement$operatio3 = linkElement.operationRef) === null || _linkElement$operatio3 === void 0 ? void 0 : _linkElement$operatio3.meta.set('operation', operationElement);
      } else if (isStringElement(linkElement.operationId)) {
        var _linkElement$operatio4, _linkElement$operatio5;
        const operationId = (_linkElement$operatio4 = linkElement.operationId) === null || _linkElement$operatio4 === void 0 ? void 0 : _linkElement$operatio4.toValue();
        const reference = await this.toReference(url.unsanitize(this.reference.uri));
        operationElement = find(e => isOperationElement(e) && e.operationId.equals(operationId), reference.value.result);
        // OperationElement not found by its operationId
        if (isUndefined(operationElement)) {
          throw new Error(`OperationElement(operationId=${operationId}) not found.`);
        }
        (_linkElement$operatio5 = linkElement.operationId) === null || _linkElement$operatio5 === void 0 ? void 0 : _linkElement$operatio5.meta.set('operation', operationElement);
      }
      return undefined;
    },
    async ExampleElement(exampleElement) {
      var _exampleElement$exter;
      // ignore ExampleElement without externalValue field
      if (!isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // ignore resolving ExampleElement externalValue
      if (!this.options.resolve.external && isStringElement(exampleElement.externalValue)) {
        return undefined;
      }

      // value and externalValue fields are mutually exclusive
      if (exampleElement.hasKey('value') && isStringElement(exampleElement.externalValue)) {
        throw new Error('ExampleElement value and externalValue fields are mutually exclusive.');
      }
      const reference = await this.toReference((_exampleElement$exter = exampleElement.externalValue) === null || _exampleElement$exter === void 0 ? void 0 : _exampleElement$exter.toValue());

      // shallow clone of the referenced element
      const valueElement = new reference.value.result.constructor(reference.value.result.content, reference.value.result.meta.clone(), reference.value.result.attributes.clone());
      // annotate operation element with info about origin
      valueElement.setMetaProperty('ref-origin', reference.uri);

      // eslint-disable-next-line no-param-reassign
      exampleElement.value = valueElement;
      return undefined;
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      var _referencingElement$$8;
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

      // skip current referencing schema as $ref keyword was not defined
      if (!isStringElement(referencingElement.$ref)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }

      // detect possible cycle in traversal and avoid it
      if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
        // skip processing this schema and all it's child schemas
        return false;
      }

      // compute baseURI using rules around $id and $ref keywords
      let reference = await this.toReference(url.unsanitize(this.reference.uri));
      let {
        uri: retrievalURI
      } = reference;
      const $refBaseURI = resolveSchema$refField(retrievalURI, referencingElement);
      const $refBaseURIStrippedHash = url.stripHash($refBaseURI);
      const file = File({
        uri: $refBaseURIStrippedHash
      });
      const isUnknownURI = none(r => r.canRead(file), this.options.resolve.resolvers);
      const isURL = !isUnknownURI;
      const isExternal = isURL && retrievalURI !== $refBaseURIStrippedHash;

      // ignore resolving external Schema Objects
      if (!this.options.resolve.external && isExternal) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }
      this.indirections.push(referencingElement);

      // determining reference, proper evaluation and selection mechanism
      let referencedElement;
      try {
        if (isUnknownURI || isURL) {
          // we're dealing with canonical URI or URL with possible fragment
          const selector = $refBaseURI;
          referencedElement = uriEvaluate(selector,
          // @ts-ignore
          maybeRefractToSchemaElement(reference.value.result));
        } else {
          // we're assuming here that we're dealing with JSON Pointer here
          reference = await this.toReference(url.unsanitize($refBaseURI));
          const selector = uriToPointer($refBaseURI);
          referencedElement = maybeRefractToSchemaElement(
          // @ts-ignore
          jsonPointerEvaluate(selector, reference.value.result));
        }
      } catch (error) {
        /**
         * No SchemaElement($id=URL) was not found, so we're going to try to resolve
         * the URL and assume the returned response is a JSON Schema.
         */
        if (isURL && error instanceof EvaluationJsonSchemaUriError) {
          if (isAnchor(uriToAnchor($refBaseURI))) {
            // we're dealing with JSON Schema $anchor here
            reference = await this.toReference(url.unsanitize($refBaseURI));
            retrievalURI = reference.uri;
            const selector = uriToAnchor($refBaseURI);
            referencedElement = $anchorEvaluate(selector,
            // @ts-ignore
            maybeRefractToSchemaElement(reference.value.result));
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            reference = await this.toReference(url.unsanitize($refBaseURI));
            retrievalURI = reference.uri;
            const selector = uriToPointer($refBaseURI);
            referencedElement = maybeRefractToSchemaElement(
            // @ts-ignore
            jsonPointerEvaluate(selector, reference.value.result));
          }
        } else {
          throw error;
        }
      }

      // detect direct or indirect reference
      if (this.indirections.includes(referencedElement)) {
        throw new Error('Recursive Schema Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // append referencing schema to ancestors lineage
      directAncestors.add(referencingElement);

      // dive deep into the fragment
      const visitor = OpenApi3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap,
        nodeTypeGetter: getNodeType
      });

      // remove referencing schema from ancestors lineage
      directAncestors.delete(referencingElement);
      this.indirections.pop();

      // Boolean JSON Schemas
      if (isBooleanJsonSchemaElement(referencedElement)) {
        var _referencingElement$$7;
        const referencedElementClone = referencedElement.clone();
        // annotate referenced element with info about original referencing element
        referencedElementClone.setMetaProperty('ref-fields', {
          $ref: (_referencingElement$$7 = referencingElement.$ref) === null || _referencingElement$$7 === void 0 ? void 0 : _referencingElement$$7.toValue()
        });
        // annotate referenced element with info about origin
        referencedElementClone.setMetaProperty('ref-origin', reference.uri);
        return referencedElementClone;
      }

      // Schema Object - merge keywords from referenced schema with referencing schema
      const mergedResult = new SchemaElement(
      // @ts-ignore
      [...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
      // existing keywords from referencing schema overrides ones from referenced schema
      referencingElement.forEach((value, keyElement, item) => {
        mergedResult.remove(keyElement.toValue());
        mergedResult.content.push(item);
      });
      mergedResult.remove('$ref');
      // annotate referenced element with info about original referencing element
      mergedResult.setMetaProperty('ref-fields', {
        $ref: (_referencingElement$$8 = referencingElement.$ref) === null || _referencingElement$$8 === void 0 ? void 0 : _referencingElement$$8.toValue()
      });
      // annotate fragment with info about origin
      mergedResult.setMetaProperty('ref-origin', reference.uri);

      // transclude referencing element with merged referenced element
      return mergedResult;
    }
  }
});
export default OpenApi3_1DereferenceVisitor;