import File from "./util/File.js";
import * as url from "./util/url.js";
import defaultOptions from "./options/index.js";
import { merge as mergeOptions } from "./options/util.js";
import parseFn from "./parse/index.js";
import resolveFn, { resolveApiDOM as resolveApiDOMFn } from "./resolve/index.js";
import { readFile as readFileFn } from "./resolve/util.js";
import dereferenceFn, { dereferenceApiDOM as dereferenceApiDOMFn } from "./dereference/index.js";
export { url, File };
export { default as Parser } from "./parse/parsers/Parser.js";
export { default as Resolver } from "./resolve/resolvers/Resolver.js";
export { default as HttpResolver } from "./resolve/resolvers/HttpResolver.js";
export { default as ResolveStrategy } from "./resolve/strategies/ResolveStrategy.js";
export { default as DereferenceStrategy } from "./dereference/strategies/DereferenceStrategy.js";
export { default as options } from "./options/index.js";
export { merge as mergeOptions } from "./options/util.js";
export { default as Reference } from "./Reference.js";
export { default as ReferenceSet } from "./ReferenceSet.js";
export { DereferenceError, InvalidSelectorError, MaximumDereferenceDepthError, MaximumResolverDepthError, NotImplementedError, ParserError, PluginError, ResolverError, UnmatchedDereferenceStrategyError, UnmatchedResolveStrategyError, UnmatchedResolverError } from "./util/errors/index.js";
export const readFile = async (uri, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  const file = File({
    uri: url.sanitize(uri)
  });
  return readFileFn(file, mergedOptions);
};
export const parse = async (uri, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  return parseFn(uri, mergedOptions);
};
export const resolve = async (uri, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  return resolveFn(uri, mergedOptions);
};
export const resolveApiDOM = async (element, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  return resolveApiDOMFn(element, mergedOptions);
};
export const dereference = async (uri, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  return dereferenceFn(uri, mergedOptions);
};
export const dereferenceApiDOM = async (element, options = {}) => {
  const mergedOptions = mergeOptions(defaultOptions, options);
  return dereferenceApiDOMFn(element, mergedOptions);
};