import stampit from 'stampit';
import { pick } from 'ramda';
import { parse, mediaTypes, detect } from '@swagger-api/apidom-parser-adapter-openapi-json-3-1';
import { ParserError } from "../../../util/errors/index.js";
import Parser from "../Parser.js"; // eslint-disable-next-line @typescript-eslint/naming-convention
const OpenApiJson3_1Parser = stampit(Parser, {
  props: {
    name: 'openapi-json-3-1',
    fileExtensions: ['.json'],
    mediaTypes
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        return detect(file.toString());
      }
      return false;
    },
    async parse(file) {
      const source = file.toString();
      try {
        const parserOpts = pick(['sourceMap', 'syntacticAnalysis', 'refractorOpts'], this);
        return await parse(source, parserOpts);
      } catch (error) {
        throw new ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
export default OpenApiJson3_1Parser;