import stampit from 'stampit';
import { parse, mediaTypes, detect } from '@swagger-api/apidom-parser-adapter-yaml-1-2';
import { ParserError } from "../../../util/errors/index.js";
import Parser from "../Parser.js";
const YamlParser = stampit(Parser, {
  props: {
    name: 'yaml-1-2',
    fileExtensions: ['.yaml', '.yml'],
    mediaTypes
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        return detect(file.toString());
      }
      return false;
    },
    async parse(file) {
      const source = file.toString();
      try {
        return await parse(source, {
          sourceMap: this.sourceMap
        });
      } catch (error) {
        throw new ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
export default YamlParser;