import stampit from 'stampit';
import Resolver from "./Resolver.js";
import * as url from "../../util/url.js";
import NotImplementedError from "../../util/errors/NotImplementedError.js";
const HttpResolver = stampit(Resolver, {
  props: {
    timeout: 5000,
    redirects: 5,
    withCredentials: false
  },
  init({
    timeout = this.timeout,
    redirects = this.redirects,
    withCredentials = this.withCredentials
  } = {}) {
    this.timeout = timeout;
    this.redirects = redirects;
    this.withCredentials = withCredentials;
  },
  methods: {
    canRead(file) {
      return url.isHttpUrl(file.uri);
    },
    async read() {
      throw new NotImplementedError();
    },
    getHttpClient() {
      throw new NotImplementedError();
    }
  }
});
export default HttpResolver;