import { readFile } from '#fs'; // eslint-disable-line import/order
import { promisify } from '#util'; // eslint-disable-line import/order
import stampit from 'stampit';
import minimatch from 'minimatch';
import Resolver from "../Resolver.js";
import * as url from "../../../util/url.js";
import { ResolverError } from "../../../util/errors/index.js";
const FileResolver = stampit(Resolver, {
  props: {
    name: 'file',
    fileAllowList: []
  },
  init({
    fileAllowList = this.fileAllowList
  }) {
    this.fileAllowList = fileAllowList;
  },
  methods: {
    canRead(file) {
      return url.isFileSystemPath(file.uri) && this.fileAllowList.some(pattern => {
        return typeof pattern === 'string' ? minimatch(file.uri, pattern, {
          matchBase: true
        }) : pattern.test(file.uri);
      });
    },
    async read(file) {
      const fileSystemPath = url.toFileSystemPath(file.uri);
      try {
        return await promisify(readFile)(fileSystemPath);
      } catch (error) {
        throw new ResolverError(`Error opening file "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
export default FileResolver;