import stampit from 'stampit';
import { type } from 'ramda';
import { isString } from 'ramda-adjunct';
import * as url from "./url.js";
/**
 * This stamp represents a File object with url and data.
 */

const File = stampit({
  props: {
    uri: null,
    mediaType: 'text/plain',
    data: null,
    parseResult: null
  },
  init({
    uri = this.uri,
    mediaType = this.mediaType,
    data = this.data,
    parseResult = this.parseResult
  } = {}) {
    this.uri = uri;
    this.mediaType = mediaType;
    this.data = data;
    this.parseResult = parseResult;
  },
  methods: {
    get extension() {
      if (isString(this.uri)) {
        return url.getExtension(this.uri);
      }
      return '';
    },
    toString() {
      if (typeof this.data === 'string') {
        return this.data;
      }
      if (this.data instanceof ArrayBuffer || ['ArrayBuffer'].includes(type(this.data)) || ArrayBuffer.isView(this.data)) {
        const textDecoder = new TextDecoder('utf-8');
        return textDecoder.decode(this.data);
      }
      return String(this.data);
    }
  }
});
export default File;