import { hasIn } from 'ramda';
import { isPlainObject } from 'ramda-adjunct';

/**
 * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
 * Node.js is >= 16.9.0 supports error causes natively.
 */
class CausedError extends Error {
  constructor(message, options) {
    super(message);
    this.name = this.constructor.name;
    this.message = message;
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }
    if (isPlainObject(options) && hasIn('cause', options) && !hasIn('cause', this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (hasIn('stack', cause)) {
        this.stack = `${this.stack}\nCAUSE: ${cause === null || cause === void 0 ? void 0 : cause.stack}`;
      }
    }
  }
}
export default CausedError;