"use strict";

exports.__esModule = true;
exports.uriToAnchor = exports.parse = exports.isAnchor = exports.evaluate = void 0;
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var _url = require("../../../../../util/url.cjs");
var _index = require("./errors/index.cjs");
exports.EvaluationJsonSchema$anchorError = _index.EvaluationJsonSchema$anchorError;
exports.InvalidJsonSchema$anchorError = _index.InvalidJsonSchema$anchorError;
// isAnchor :: String -> Boolean
const isAnchor = uri => {
  /**
   *  MUST start with a letter ([A-Za-z]) or underscore ("_"), followed by any number of letters,
   *  digits ([0-9]), hyphens ("-"), underscores ("_"), and periods (".").
   *
   *  https://json-schema.org/draft/2020-12/json-schema-core.html#rfc.section.8.2.2
   */
  return /^[A-Za-z_][A-Za-z_0-9.-]*$/.test(uri);
};

// uriToAnchor :: String -> String
exports.isAnchor = isAnchor;
const uriToAnchor = uri => {
  const hash = (0, _url.getHash)(uri);
  return (0, _ramdaAdjunct.trimCharsStart)('#', hash);
};

// parse :: String -> String
exports.uriToAnchor = uriToAnchor;
const parse = anchor => {
  if (!isAnchor(anchor)) {
    throw new _index.InvalidJsonSchema$anchorError(anchor);
  }
  return anchor;
};

// evaluates JSON Schema $anchor against ApiDOM fragment
exports.parse = parse;
const evaluate = (anchor, element) => {
  const token = parse(anchor);

  // @ts-ignore
  const result = (0, _apidomCore.find)(e => {
    var _e$$anchor;
    return (0, _apidomNsOpenapi.isSchemaElement)(e) && ((_e$$anchor = e.$anchor) === null || _e$$anchor === void 0 ? void 0 : _e$$anchor.toValue()) === token;
  }, element);
  if ((0, _ramdaAdjunct.isUndefined)(result)) {
    throw new _index.EvaluationJsonSchema$anchorError(`Evaluation failed on token: "${token}"`);
  }

  // @ts-ignore
  return result;
};
exports.evaluate = evaluate;